/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.impl.GeneratedMarkerVisitor;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocMemberReference;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocReferenceElement;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocTag;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.GrLambdaExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationNameValuePair;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrCatchClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrClassInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrConstructorInvocation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrTryCatchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseSection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCommandArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrEnumTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrExtendsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrImplementsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTraitTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstant;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.GrTopStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrClosureParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrClassReferenceType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyDummyElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyFileImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyNamesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.ErrorUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStringUtil;

public class GroovyPsiElementFactoryImpl
extends GroovyPsiElementFactory {
    private static final Logger LOG = Logger.getInstance(GroovyPsiElementFactoryImpl.class);
    private final Project myProject;
    private final PsiManager myManager;

    public GroovyPsiElementFactoryImpl(Project project) {
        this.myProject = project;
        this.myManager = PsiManager.getInstance((Project)project);
    }

    @Override
    @NotNull
    public PsiElement createReferenceNameFromText(@NotNull String refName) {
        GroovyFile file = this.createGroovyFileChecked("a." + refName);
        GrTopStatement statement = file.getTopStatements()[0];
        if (!(statement instanceof GrReferenceExpression)) {
            throw new IncorrectOperationException("Incorrect reference name: " + refName);
        }
        PsiElement element = ((GrReferenceExpression)statement).getReferenceNameElement();
        if (element == null) {
            throw new IncorrectOperationException("Incorrect reference name: " + refName);
        }
        return element;
    }

    @Override
    @NotNull
    public PsiElement createDocMemberReferenceNameFromText(@NotNull String idText) {
        GrDocMemberReference reference = this.createDocMemberReferenceFromText("Foo", idText);
        LOG.assertTrue(reference != null, (Object)idText);
        return reference.getReferenceNameElement();
    }

    @Override
    @NotNull
    public GrDocMemberReference createDocMemberReferenceFromText(@NotNull String className, @NotNull String text) {
        GroovyFile file = this.createGroovyFileChecked("/** @see " + className + "#" + text + " */");
        PsiElement element = file.getFirstChild();
        assert (element instanceof GrDocComment);
        GrDocTag tag = (GrDocTag)PsiTreeUtil.getChildOfType((PsiElement)element, GrDocTag.class);
        assert (tag != null) : "Doc tag points to null";
        return (GrDocMemberReference)PsiTreeUtil.getChildOfType((PsiElement)tag, GrDocMemberReference.class);
    }

    @Override
    @NotNull
    public GrDocReferenceElement createDocReferenceElementFromFQN(@NotNull String qName) {
        GroovyFile file = this.createGroovyFileChecked("/** @see " + qName + " */");
        PsiElement element = file.getFirstChild();
        assert (element instanceof GrDocComment);
        GrDocTag tag = (GrDocTag)PsiTreeUtil.getChildOfType((PsiElement)element, GrDocTag.class);
        assert (tag != null) : "Doc tag points to null";
        return (GrDocReferenceElement)PsiTreeUtil.getChildOfType((PsiElement)tag, GrDocReferenceElement.class);
    }

    @Override
    @NotNull
    public GrCodeReferenceElement createCodeReference(@NotNull String text, @Nullable PsiElement context) {
        return this.createElementFromText(text, context, GroovyElementTypes.CODE_REFERENCE, GrCodeReferenceElement.class);
    }

    @Override
    @NotNull
    public GrReferenceExpression createReferenceExpressionFromText(@NotNull String idText) {
        GroovyFile file = this.createGroovyFileChecked(idText);
        GrTopStatement[] statements2 = file.getTopStatements();
        if (statements2.length != 1 || !(statements2[0] instanceof GrReferenceExpression)) {
            throw new IncorrectOperationException(idText);
        }
        return (GrReferenceExpression)statements2[0];
    }

    @Override
    @NotNull
    public GrReferenceExpression createReferenceExpressionFromText(@NotNull String idText, PsiElement context) {
        GroovyFile file = this.createGroovyFileChecked(idText, false, context);
        GrTopStatement[] statements2 = file.getTopStatements();
        if (statements2.length != 1) {
            throw new IncorrectOperationException("refText: " + idText);
        }
        if (!(statements2[0] instanceof GrReferenceExpression)) {
            throw new IncorrectOperationException("refText: " + idText);
        }
        return (GrReferenceExpression)statements2[0];
    }

    @Override
    @NotNull
    public GrReferenceExpression createReferenceElementForClass(@NotNull PsiClass aClass) {
        String text = aClass instanceof PsiAnonymousClass ? ((PsiAnonymousClass)aClass).getBaseClassType().getPresentableText() : aClass.getName();
        return this.createReferenceExpressionFromText(text);
    }

    @Override
    @NotNull
    public GrExpression createExpressionFromText(@NotNull String text, PsiElement context) {
        GroovyFile file = this.createGroovyFile(text, false, context);
        GrTopStatement[] topStatements = file.getTopStatements();
        if (topStatements.length == 0 || !(topStatements[0] instanceof GrExpression)) {
            throw new IncorrectOperationException("incorrect expression = '" + text + "'");
        }
        return (GrExpression)topStatements[0];
    }

    @NotNull
    public GrCodeReferenceElement createReferenceElementByType(PsiClassType type2) {
        if (type2 instanceof GrClassReferenceType) {
            return ((GrClassReferenceType)type2).getReference();
        }
        PsiClassType.ClassResolveResult resolveResult2 = type2.resolveGenerics();
        PsiClass refClass = resolveResult2.getElement();
        assert (refClass != null) : type2;
        return this.createCodeReference(type2.getCanonicalText());
    }

    @NotNull
    public PsiTypeParameterList createTypeParameterList() {
        return this.createMethodFromText("def <> void foo(){}").getTypeParameterList();
    }

    @NotNull
    public PsiTypeParameter createTypeParameter(@NotNull String name, PsiClassType @NotNull [] superTypes) {
        StringBuilder builder = new StringBuilder();
        builder.append("def <").append(name);
        if (superTypes.length > 1 || superTypes.length == 1 && !superTypes[0].equalsToText("java.lang.Object")) {
            builder.append(" extends ");
            for (PsiClassType type2 : superTypes) {
                if (type2.equalsToText("java.lang.Object")) continue;
                builder.append(type2.getCanonicalText()).append(',');
            }
            builder.delete(builder.length() - 1, builder.length());
        }
        builder.append("> void foo(){}");
        try {
            return this.createMethodFromText(builder).getTypeParameters()[0];
        }
        catch (RuntimeException e) {
            throw new IncorrectOperationException("type parameter text: " + builder);
        }
    }

    @Override
    @NotNull
    public GrVariableDeclaration createVariableDeclaration(String @Nullable [] modifiers, @Nullable GrExpression initializer, @Nullable PsiType type2, String ... identifiers) {
        String initializerText;
        if (initializer != null) {
            if (initializer instanceof GrApplicationStatement && !GroovyConfigUtils.getInstance().isVersionAtLeast(initializer, "1.8", false)) {
                initializer = this.createMethodCallByAppCall((GrApplicationStatement)initializer);
            }
            assert (initializer != null);
            initializerText = initializer.getText();
        } else {
            initializerText = null;
        }
        return this.createVariableDeclaration(modifiers, initializerText, type2, identifiers);
    }

    @Override
    @NotNull
    public GrVariableDeclaration createVariableDeclaration(String @Nullable [] modifiers, @Nullable String initializer, @Nullable PsiType type2, String ... identifiers) {
        GrTopStatement[] topStatements;
        StringBuilder text = GroovyPsiElementFactoryImpl.writeModifiers(modifiers);
        if (type2 != null && type2 != PsiType.NULL) {
            PsiType unboxed = TypesUtil.unboxPrimitiveTypeWrapper(type2);
            String typeText = GroovyPsiElementFactoryImpl.getTypeText(unboxed);
            text.append(typeText).append(" ");
        } else if (text.length() == 0) {
            text.insert(0, "def ");
        }
        if (identifiers.length > 1 && initializer != null) {
            text.append('(');
        }
        text.append(String.join((CharSequence)", ", identifiers));
        if (identifiers.length > 1 && initializer != null) {
            text.append(')');
        }
        if (!StringUtil.isEmptyOrSpaces((String)initializer)) {
            text.append(" = ").append(initializer);
        }
        if ((topStatements = this.createGroovyFileChecked(text).getTopStatements()).length == 0 || !(topStatements[0] instanceof GrVariableDeclaration)) {
            topStatements = this.createGroovyFileChecked("def " + text).getTopStatements();
        }
        if (topStatements.length == 0 || !(topStatements[0] instanceof GrVariableDeclaration)) {
            throw new RuntimeException("Invalid arguments, text = " + text);
        }
        GrVariableDeclaration statement = (GrVariableDeclaration)topStatements[0];
        CodeEditUtil.markToReformatBefore((ASTNode)statement.getNode().findLeafElementAt(0), (boolean)true);
        return statement;
    }

    @Override
    @NotNull
    public GrEnumConstant createEnumConstantFromText(@NotNull String text) {
        GroovyFile file = this.createGroovyFileChecked("enum E{" + text + "}");
        GrEnumTypeDefinition enumClass = (GrEnumTypeDefinition)file.getClasses()[0];
        return enumClass.getEnumConstants()[0];
    }

    @Override
    @NotNull
    public GrVariableDeclaration createFieldDeclaration(String @NotNull [] modifiers, @NotNull String identifier, @Nullable GrExpression initializer, @Nullable PsiType type2) {
        String varDeclaration = this.createVariableDeclaration(modifiers, initializer, type2, identifier).getText();
        GroovyFile file = this.createGroovyFileChecked("class A { " + varDeclaration + "}");
        GrTypeDefinitionBody body = file.getTypeDefinitions()[0].getBody();
        LOG.assertTrue(body.getMemberDeclarations().length == 1 && body.getMemberDeclarations()[0] instanceof GrVariableDeclaration, (Object)("ident = <" + identifier + "> initializer = " + (initializer == null ? "_null_" : "<" + initializer.getText() + ">")));
        return (GrVariableDeclaration)body.getMemberDeclarations()[0];
    }

    @Override
    @NotNull
    public GrVariableDeclaration createFieldDeclarationFromText(@NotNull String text) {
        GroovyFile file = this.createGroovyFileChecked("class X{\n" + text + "\n}");
        PsiClass psiClass = file.getClasses()[0];
        return (GrVariableDeclaration)psiClass.getFields()[0].getParent();
    }

    private static StringBuilder writeModifiers(String[] modifiers) {
        StringBuilder text = new StringBuilder();
        if (modifiers != null && modifiers.length != 0) {
            for (String modifier : modifiers) {
                text.append(modifier);
                text.append(" ");
            }
        }
        return text;
    }

    private static String getTypeText(PsiType type2) {
        if (!(type2 instanceof PsiArrayType)) {
            String text;
            String canonical = type2.getCanonicalText();
            String string = text = canonical != null ? canonical : type2.getPresentableText();
            if ("null".equals(text)) {
                return "";
            }
            return text;
        }
        return GroovyPsiElementFactoryImpl.getTypeText(((PsiArrayType)type2).getComponentType()) + "[]";
    }

    @Override
    @NotNull
    public GrTopStatement createTopElementFromText(@NotNull String text) {
        GroovyFile dummyFile = this.createGroovyFileChecked(text);
        GrTopStatement[] topStatements = dummyFile.getTopStatements();
        if (topStatements.length != 1) {
            throw new IncorrectOperationException("text = '" + text + "'");
        }
        return topStatements[0];
    }

    @Override
    @NotNull
    public GrClosableBlock createClosureFromText(@NotNull String closureText, PsiElement context) throws IncorrectOperationException {
        return this.createElementFromText(closureText, context, (IElementType)GroovyElementTypes.CLOSURE, GrClosableBlock.class);
    }

    @Override
    @NotNull
    public GrLambdaExpression createLambdaFromText(@NotNull String lambdaText, PsiElement context) throws IncorrectOperationException {
        return this.createElementFromText(lambdaText, context, GroovyElementTypes.LAMBDA_EXPRESSION, GrLambdaExpression.class);
    }

    private GroovyFileImpl createDummyFile(@NotNull CharSequence text, boolean physical) {
        String fileName = "DUMMY__1234567890_DUMMYYYYYY___." + GroovyFileType.GROOVY_FILE_TYPE.getDefaultExtension();
        long stamp = System.currentTimeMillis();
        PsiFileFactory factory = PsiFileFactory.getInstance((Project)this.myProject);
        return (GroovyFileImpl)factory.createFileFromText(fileName, (FileType)GroovyFileType.GROOVY_FILE_TYPE, text, stamp, physical);
    }

    @Override
    @NotNull
    public GrParameter createParameter(@NotNull String name, @Nullable String typeText, @Nullable String initializer, @Nullable GroovyPsiElement context, String ... modifiers) throws IncorrectOperationException {
        try {
            StringBuilder fileText = new StringBuilder();
            fileText.append("def dsfsadfnbhfjks_weyripouh_huihnrecuio(");
            for (String modifier : modifiers) {
                fileText.append(modifier).append(' ');
            }
            if (StringUtil.isNotEmpty((String)typeText)) {
                fileText.append(typeText).append(' ');
            }
            fileText.append(name);
            if (initializer != null && !initializer.isEmpty()) {
                fileText.append(" = ").append(initializer);
            }
            fileText.append("){}");
            GroovyFile groovyFile = this.createGroovyFileChecked(fileText, false, context);
            ASTNode node = groovyFile.getFirstChild().getNode();
            return ((GrMethod)node.getPsi()).getParameters()[0];
        }
        catch (RuntimeException e) {
            throw new IncorrectOperationException("name = " + name + ", type = " + typeText + ", initializer = " + initializer);
        }
    }

    @Override
    @NotNull
    public GrTypeDefinition createTypeDefinition(@NotNull String text) throws IncorrectOperationException {
        GroovyFile file = this.createGroovyFileChecked(text);
        GrTypeDefinition[] classes2 = file.getTypeDefinitions();
        if (classes2.length != 1) {
            throw new IncorrectOperationException("Incorrect type definition text");
        }
        return classes2[0];
    }

    @Override
    @NotNull
    public GrTypeElement createTypeElement(@NotNull String typeText, @Nullable PsiElement context) throws IncorrectOperationException {
        return this.createElementFromText(typeText, context, GroovyElementTypes.TYPE_ELEMENT, GrTypeElement.class);
    }

    @Override
    @NotNull
    public GrTypeElement createTypeElement(@NotNull PsiType type2) throws IncorrectOperationException {
        String typeText = GroovyPsiElementFactoryImpl.getTypeText(type2);
        if (typeText == null) {
            throw new IncorrectOperationException("Cannot create type element: cannot obtain text for type");
        }
        return this.createTypeElement(typeText);
    }

    @NotNull
    public PsiClassType createType(@NotNull PsiClass aClass) {
        return JavaPsiFacade.getElementFactory((Project)this.myProject).createType(aClass);
    }

    @Override
    @NotNull
    public GrParenthesizedExpression createParenthesizedExpr(@NotNull GrExpression expression, @Nullable PsiElement context) {
        return (GrParenthesizedExpression)this.createExpressionFromText("(" + expression.getText() + ")", context);
    }

    @Override
    @NotNull
    public PsiElement createStringLiteralForReference(@NotNull String text) {
        return this.createLiteralFromValue(text).getFirstChild();
    }

    @Override
    @NotNull
    public PsiElement createModifierFromText(@NotNull String name) {
        GroovyFile file = this.createGroovyFileChecked(name + " foo() {}");
        GrTopStatement[] definitions = file.getTopStatements();
        if (definitions.length != 1) {
            throw new IncorrectOperationException(name);
        }
        return definitions[0].getFirstChild().getFirstChild();
    }

    @Override
    @NotNull
    public GrCodeBlock createMethodBodyFromText(@NotNull String text) {
        GroovyFile file = this.createGroovyFileChecked("def foo () {" + text + "}");
        GrMethod method = (GrMethod)file.getTopStatements()[0];
        return method.getBlock();
    }

    @Override
    @NotNull
    public GrVariableDeclaration createSimpleVariableDeclaration(@NotNull String name, @NotNull String typeText) {
        String classText = Character.isLowerCase(typeText.charAt(0)) ? "class A { def " + typeText + " " + name + "}" : "class A { " + typeText + " " + name + "}";
        GroovyFile file = this.createGroovyFileChecked(classText);
        GrTypeDefinitionBody body = file.getTypeDefinitions()[0].getBody();
        return (GrVariableDeclaration)body.getMemberDeclarations()[0];
    }

    @Override
    @NotNull
    public PsiElement createDotToken(@NotNull String newDot) {
        return this.createReferenceExpressionFromText("a" + newDot + "b").getDotToken();
    }

    @Override
    @NotNull
    public GrMethod createConstructorFromText(@NotNull String constructorName, String @Nullable [] paramTypes, String @NotNull [] paramNames, @Nullable String body, @Nullable PsiElement context) {
        CharSequence text = GroovyPsiElementFactoryImpl.generateMethodText(null, constructorName, null, paramTypes, paramNames, body, true);
        return this.createConstructorFromText(constructorName, text, context);
    }

    @Override
    @NotNull
    public GrMethod createConstructorFromText(String constructorName, CharSequence constructorText, @Nullable PsiElement context) {
        GroovyFile file = this.createGroovyFileChecked("class " + constructorName + "{" + constructorText + "}", false, context);
        GrTypeDefinition definition = file.getTypeDefinitions()[0];
        if (definition == null) {
            throw new IncorrectOperationException("constructorName: " + constructorName + ", text: " + constructorText);
        }
        GrMethod[] methods = definition.getCodeMethods();
        if (methods.length != 1) {
            throw new IncorrectOperationException("constructorName: " + constructorName + ", text: " + constructorText);
        }
        return methods[0];
    }

    @Override
    @NotNull
    public GrMethod createMethodFromText(String methodText, @Nullable PsiElement context) {
        if (methodText == null) {
            throw new IncorrectOperationException("Method text not provided");
        }
        GroovyFile file = this.createGroovyFile(methodText, false, context);
        GrTopStatement[] definitions = file.getTopStatements();
        if (definitions.length != 1) {
            throw new IncorrectOperationException("Can't create method from text: '" + file.getText() + "'");
        }
        GrTopStatement definition = definitions[0];
        if (!(definition instanceof GrMethod)) {
            throw new IncorrectOperationException("Can't create method from text: '" + file.getText() + "'");
        }
        return (GrMethod)definition;
    }

    @Override
    @NotNull
    public GrAnnotation createAnnotationFromText(@NotNull @NonNls String annotationText, @Nullable PsiElement context) {
        return this.createElementFromText(annotationText, context, (IElementType)GroovyElementTypes.ANNOTATION, GrAnnotation.class);
    }

    @Override
    @NotNull
    public GrAnnotationNameValuePair createAnnotationAttribute(@NotNull String text, @Nullable PsiElement context) {
        return this.createElementFromText(text, context, (IElementType)GroovyElementTypes.ANNOTATION_MEMBER_VALUE_PAIR, GrAnnotationNameValuePair.class);
    }

    @Override
    @NotNull
    public GrMethod createMethodFromSignature(@NotNull String name, @NotNull GrSignature signature) {
        StringBuilder builder = new StringBuilder("public");
        PsiType returnType2 = signature.getReturnType();
        if (returnType2 != null && returnType2 != PsiType.NULL) {
            builder.append(' ');
            builder.append(returnType2.getCanonicalText());
        }
        builder.append(' ').append(name).append('(');
        int i = 0;
        for (GrClosureParameter parameter : signature.getParameters()) {
            PsiType type2 = parameter.getType();
            if (type2 != null) {
                builder.append(type2.getCanonicalText());
                builder.append(' ');
            }
            builder.append('p').append(++i);
            GrExpression initializer = parameter.getDefaultInitializer();
            if (initializer == null) continue;
            builder.append(" = ").append(initializer.getText());
            builder.append(", ");
        }
        if (signature.getParameterCount() > 0) {
            builder.delete(builder.length() - 2, builder.length());
        }
        builder.append("){}");
        return this.createMethodFromText(builder);
    }

    @Override
    @NotNull
    public GrAnnotation createAnnotationFromText(@NotNull String annoText) {
        return this.createAnnotationFromText(annoText, null);
    }

    private GroovyFile createGroovyFileChecked(@NotNull CharSequence idText) {
        return this.createGroovyFileChecked(idText, false, null);
    }

    private GroovyFile createGroovyFileChecked(@NotNull CharSequence idText, boolean isPhysical, @Nullable PsiElement context) {
        GroovyFileImpl file = this.createDummyFile(idText, isPhysical);
        if (ErrorUtil.containsError(file)) {
            throw new IncorrectOperationException("cannot create file from text: " + idText);
        }
        file.setContext(context);
        return file;
    }

    @Override
    @NotNull
    public GroovyFile createGroovyFile(@NotNull CharSequence idText, boolean isPhysical, @Nullable PsiElement context) {
        GroovyFileImpl file = this.createDummyFile(idText, isPhysical);
        file.setContext(context);
        return file;
    }

    @Override
    @NotNull
    public PsiElement createWhiteSpace() {
        GroovyFileImpl dummyFile = this.createDummyFile(" ", false);
        return dummyFile.getFirstChild();
    }

    @Override
    @NotNull
    public PsiElement createLineTerminator(int length) {
        String text;
        String string = text = length <= 1 ? "\n" : "";
        if (length > 1) {
            text = StringUtil.repeatSymbol((char)'\n', (int)length);
        }
        return this.createLineTerminator(text);
    }

    @Override
    @NotNull
    public PsiElement createLineTerminator(@NotNull String text) {
        GroovyFile dummyFile = this.createGroovyFileChecked(text);
        PsiElement child = dummyFile.getFirstChild();
        assert (child != null);
        return child;
    }

    @Override
    @NotNull
    public GrArgumentList createExpressionArgumentList(GrExpression ... expressions) {
        StringBuilder text = new StringBuilder();
        text.append("ven (");
        for (GrExpression expression : expressions) {
            text.append(expression.getText()).append(", ");
        }
        if (expressions.length > 0) {
            text.delete(text.length() - 2, text.length());
        }
        text.append(')');
        GroovyFile file = this.createGroovyFileChecked(text);
        assert (file.getChildren()[0] != null && file.getChildren()[0] instanceof GrMethodCallExpression);
        return ((GrMethodCallExpression)file.getChildren()[0]).getArgumentList();
    }

    @Override
    @NotNull
    public GrNamedArgument createNamedArgument(@NotNull String name, @NotNull GrExpression expression) {
        GroovyFile file = this.createGroovyFileChecked("foo (" + name + ":" + expression.getText() + ")");
        assert (file.getChildren()[0] != null);
        GrCall call = (GrCall)file.getChildren()[0];
        return call.getArgumentList().getNamedArguments()[0];
    }

    @Override
    @NotNull
    public GrStatement createStatementFromText(@NotNull CharSequence text) {
        return this.createStatementFromText(text, null);
    }

    @Override
    @NotNull
    public GrStatement createStatementFromText(@NotNull CharSequence text, @Nullable PsiElement context) {
        GroovyFile file = this.createGroovyFileChecked(text, false, context);
        GrTopStatement[] statements2 = file.getTopStatements();
        if (statements2.length != 1) {
            throw new IncorrectOperationException("count = " + statements2.length + ", " + text);
        }
        if (!(statements2[0] instanceof GrStatement)) {
            throw new IncorrectOperationException("type = " + statements2[0].getClass().getName() + ", " + text);
        }
        return (GrStatement)statements2[0];
    }

    @Override
    @NotNull
    public GrMethodCallExpression createMethodCallByAppCall(@NotNull GrApplicationStatement callExpr) {
        StringBuilder text = new StringBuilder();
        text.append(callExpr.getInvokedExpression().getText());
        text.append("(");
        GrCommandArgumentList argumentList = callExpr.getArgumentList();
        if (argumentList != null) {
            text.append(argumentList.getText());
        }
        text.append(")");
        GroovyFile file = this.createGroovyFileChecked(text);
        assert (file.getChildren()[0] != null && file.getChildren()[0] instanceof GrMethodCallExpression);
        return (GrMethodCallExpression)file.getChildren()[0];
    }

    @Override
    @NotNull
    public GrCodeReferenceElement createCodeReferenceElementFromClass(@NotNull PsiClass aClass) {
        String qualifiedName = aClass.getQualifiedName();
        if (qualifiedName == null) {
            throw new IncorrectOperationException("cannot create code reference element for class " + aClass.getText());
        }
        return this.createCodeReference(qualifiedName);
    }

    @Override
    @NotNull
    public GrReferenceExpression createThisExpression(@Nullable PsiClass psiClass) {
        String qname;
        String text = psiClass == null ? "this" : (StringUtil.isEmpty((String)(qname = psiClass.getQualifiedName())) ? "this" : qname + ".this");
        return this.createReferenceExpressionFromText(text, (PsiElement)psiClass);
    }

    @Override
    @NotNull
    public GrBlockStatement createBlockStatementFromText(@NotNull String text, @Nullable PsiElement context) {
        return this.createElementFromText(text, context, GroovyElementTypes.BLOCK_STATEMENT, GrBlockStatement.class);
    }

    @Override
    @NotNull
    public GrModifierList createModifierList(@NotNull CharSequence text) {
        GrMethod method = this.createMethodFromText(text + " void foo()");
        return method.getModifierList();
    }

    @Override
    @NotNull
    public GrCaseSection createSwitchSection(@NotNull String text) {
        GrStatement statement = this.createStatementFromText("switch (a) {\n" + text + "\n}");
        if (!(statement instanceof GrSwitchStatement)) {
            throw new IncorrectOperationException("Cannot create switch section from text: " + text);
        }
        GrCaseSection[] sections = ((GrSwitchStatement)statement).getCaseSections();
        if (sections.length != 1) {
            throw new IncorrectOperationException("Cannot create switch section from text: " + text);
        }
        return sections[0];
    }

    @Override
    @NotNull
    public GrImportStatement createImportStatementFromText(@NotNull String qName, boolean isStatic, boolean isOnDemand, String alias) {
        return this.createImportStatement(qName, isStatic, isOnDemand, alias, null);
    }

    @Override
    @NotNull
    public GrImportStatement createImportStatementFromText(@NotNull String text) {
        GroovyFile dummyFile = this.createGroovyFileChecked(text);
        return (GrImportStatement)dummyFile.getFirstChild();
    }

    @Override
    @NotNull
    public GrImportStatement createImportStatement(@NotNull String qname, boolean isStatic, boolean isOnDemand, String alias, PsiElement context) {
        StringBuilder builder = new StringBuilder();
        builder.append("import ");
        if (isStatic) {
            builder.append("static ");
        }
        builder.append(qname);
        if (isOnDemand) {
            builder.append(".*");
        }
        if (StringUtil.isNotEmpty((String)alias)) {
            builder.append(" as ").append(alias);
        }
        GroovyFile dummyFile = this.createGroovyFileChecked(builder, false, context);
        return (GrImportStatement)dummyFile.getFirstChild();
    }

    private static CharSequence generateMethodText(@Nullable String modifier, @NotNull String name, @Nullable String type2, String @NotNull [] paramTypes, String @NotNull [] paramNames, @Nullable String body, boolean isConstructor) {
        StringBuilder builder = new StringBuilder();
        if (modifier != null) {
            builder.append(modifier);
            builder.append(" ");
        }
        if (!isConstructor) {
            builder.append("def ");
        }
        if (type2 != null) {
            builder.append(type2);
            builder.append(" ");
        }
        builder.append(name);
        builder.append("(");
        for (int i = 0; i < paramNames.length; ++i) {
            String paramType;
            String string = paramType = paramTypes == null ? null : paramTypes[i];
            if (i > 0) {
                builder.append(", ");
            }
            if (paramType != null) {
                builder.append(paramType);
                builder.append(" ");
            }
            builder.append(paramNames[i]);
        }
        builder.append(")");
        if (body != null) {
            builder.append(body);
        } else {
            builder.append("{");
            builder.append("}");
        }
        return builder;
    }

    @Override
    @NotNull
    public GrMethod createMethodFromText(@NotNull String modifier, @NotNull String name, @Nullable String type2, String @NotNull [] paramTypes, PsiElement context) {
        ArrayList<PsiType> res = new ArrayList<PsiType>();
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(this.myProject);
        for (String paramType : paramTypes) {
            PsiType psiType;
            try {
                psiType = factory.createTypeElement(paramType).getType();
            }
            catch (IncorrectOperationException e) {
                psiType = TypesUtil.getJavaLangObject(context);
            }
            res.add(psiType);
        }
        String[] paramNames = GroovyNamesUtil.getMethodArgumentsNames(this.myProject, res.toArray(PsiType.createArray((int)res.size())));
        CharSequence text = GroovyPsiElementFactoryImpl.generateMethodText(modifier, name, type2, paramTypes, paramNames, null, false);
        return this.createMethodFromText(text.toString(), context);
    }

    @Override
    @NotNull
    public GrDocComment createDocCommentFromText(@NotNull String text) {
        return (GrDocComment)this.createGroovyFileChecked(text).getFirstChild();
    }

    @Override
    @NotNull
    public GrConstructorInvocation createConstructorInvocation(@NotNull String text) {
        return this.createConstructorInvocation(text, null);
    }

    @Override
    @NotNull
    public GrConstructorInvocation createConstructorInvocation(@NotNull String text, @Nullable PsiElement context) {
        GroovyFile file = this.createGroovyFileChecked("class Foo{ def Foo(){" + text + "}}", false, context);
        return PsiImplUtil.getChainingConstructorInvocation((GrMethod)file.getClasses()[0].getConstructors()[0]);
    }

    @Override
    @NotNull
    public PsiReferenceList createThrownList(PsiClassType @NotNull [] exceptionTypes) {
        if (exceptionTypes.length == 0) {
            return this.createMethodFromText("def foo(){}", null).getThrowsList();
        }
        String[] types = new String[exceptionTypes.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = exceptionTypes[i].getCanonicalText();
        }
        String end = StringUtil.join((String[])types, (String)",");
        return this.createMethodFromText("def foo() throws " + end + "{}", null).getThrowsList();
    }

    @Override
    @NotNull
    public GrCatchClause createCatchClause(@NotNull PsiClassType type2, @NotNull String parameterName) {
        StringBuilder buffer = new StringBuilder("try{} catch(");
        if (type2 == null) {
            buffer.append("Throwable ");
        } else {
            buffer.append(type2.getCanonicalText()).append(" ");
        }
        buffer.append(parameterName).append("){\n}");
        GrTryCatchStatement statement = (GrTryCatchStatement)this.createStatementFromText(buffer);
        return statement.getCatchClauses()[0];
    }

    @Override
    @NotNull
    public GrArgumentList createArgumentList() {
        return ((GrCall)((Object)this.createExpressionFromText("foo()"))).getArgumentList();
    }

    @Override
    @NotNull
    public GrArgumentList createArgumentListFromText(@NotNull String argListText) {
        try {
            return ((GrCall)((Object)this.createExpressionFromText("foo " + argListText))).getArgumentList();
        }
        catch (IncorrectOperationException e) {
            LOG.debug(argListText);
            throw e;
        }
    }

    @Override
    @NotNull
    public GrExtendsClause createExtendsClause() {
        GrTypeDefinition typeDefinition = this.createTypeDefinition("class A extends B {}");
        GrExtendsClause clause = typeDefinition.getExtendsClause();
        clause.getReferenceElementsGroovy()[0].delete();
        return clause;
    }

    @Override
    @NotNull
    public GrImplementsClause createImplementsClause() {
        GrTypeDefinition typeDefinition = this.createTypeDefinition("class A implements B {}");
        GrImplementsClause clause = typeDefinition.getImplementsClause();
        clause.getReferenceElementsGroovy()[0].delete();
        return clause;
    }

    @Override
    @NotNull
    public GrLiteral createLiteralFromValue(@Nullable Object value) {
        if (value instanceof String) {
            StringBuilder buffer = GrStringUtil.getLiteralTextByValue((String)value);
            GrExpression expr = this.createExpressionFromText(buffer);
            LOG.assertTrue(expr instanceof GrLiteral, (Object)("value = " + value));
            return (GrLiteral)expr;
        }
        if (value == null) {
            return (GrLiteral)this.createExpressionFromText("null");
        }
        if (value instanceof Boolean) {
            return (GrLiteral)this.createExpressionFromText(value.toString());
        }
        throw new IncorrectOperationException("Can not create literal from type: " + value.getClass().getName());
    }

    @NotNull
    public PsiClass createClass(@NonNls @NotNull String name) throws IncorrectOperationException {
        return this.createTypeDefinition("class " + name + "{}");
    }

    @NotNull
    public PsiClass createInterface(@NonNls @NotNull String name) throws IncorrectOperationException {
        return this.createTypeDefinition("interface " + name + "{}");
    }

    @NotNull
    public PsiClass createEnum(@NotNull @NonNls String name) throws IncorrectOperationException {
        return this.createTypeDefinition("enum " + name + "{}");
    }

    @Override
    @NotNull
    public GrField createField(@NotNull @NonNls String name, @NotNull PsiType type2) throws IncorrectOperationException {
        GrVariableDeclaration fieldDeclaration = this.createFieldDeclaration(ArrayUtilRt.EMPTY_STRING_ARRAY, name, null, type2);
        return (GrField)fieldDeclaration.getVariables()[0];
    }

    @Override
    @NotNull
    public GrTraitTypeDefinition createTrait(@NotNull String name) {
        return (GrTraitTypeDefinition)this.createTypeDefinition("trait " + name + "{}");
    }

    @Override
    @NotNull
    public GrMethod createMethod(@NotNull @NonNls String name, @Nullable PsiType returnType2) throws IncorrectOperationException {
        return this.createMethod(name, returnType2, null);
    }

    @Override
    @NotNull
    public GrMethod createMethod(@NotNull @NonNls String name, PsiType returnType2, PsiElement context) throws IncorrectOperationException {
        StringBuilder builder = new StringBuilder();
        builder.append("def <T>");
        if (returnType2 != null) {
            builder.append(returnType2.getCanonicalText());
        }
        builder.append(' ');
        if (GroovyNamesUtil.isIdentifier(name)) {
            builder.append(name);
        } else {
            builder.append('\"');
            builder.append(GrStringUtil.escapeSymbolsForGString(name, true, false));
            builder.append('\"');
        }
        builder.append("(){}");
        GrMethod method = this.createMethodFromText(builder.toString(), context);
        PsiTypeParameterList typeParameterList = method.getTypeParameterList();
        assert (typeParameterList != null);
        typeParameterList.getFirstChild().delete();
        typeParameterList.getFirstChild().delete();
        typeParameterList.getFirstChild().delete();
        if (returnType2 != null) {
            method.getModifierList().setModifierProperty("def", false);
        }
        return method;
    }

    @Override
    @NotNull
    public GrMethod createConstructor() {
        return this.createConstructorFromText("Foo", "Foo(){}", null);
    }

    @Override
    @NotNull
    public GrClassInitializer createClassInitializer() throws IncorrectOperationException {
        GrTypeDefinition typeDefinition = this.createTypeDefinition("class X {{}}");
        return typeDefinition.getInitializers()[0];
    }

    @Override
    @NotNull
    public GrParameter createParameter(@NotNull @NonNls String name, @Nullable PsiType type2) throws IncorrectOperationException {
        return this.createParameter(name, type2 == null ? null : type2.getCanonicalText(), null, null, new String[0]);
    }

    @NotNull
    public GrParameter createParameter(@NotNull @NonNls String name, @Nullable PsiType type2, PsiElement context) throws IncorrectOperationException {
        return this.createParameter(name, type2 == null ? null : type2.getCanonicalText(), null, context instanceof GroovyPsiElement ? (GroovyPsiElement)context : null, new String[0]);
    }

    @NotNull
    public PsiParameterList createParameterList(@NonNls String @NotNull [] names, PsiType @NotNull [] types) throws IncorrectOperationException {
        StringBuilder builder = new StringBuilder();
        builder.append("def foo(");
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            PsiType type2 = types[i];
            if (type2 != null) {
                builder.append(type2.getCanonicalText());
                builder.append(' ');
            }
            builder.append(name);
            builder.append(',');
        }
        if (names.length > 0) {
            builder.delete(builder.length() - 1, builder.length());
        }
        builder.append("){}");
        GrMethod method = this.createMethodFromText(builder);
        return method.getParameterList();
    }

    @NotNull
    public PsiClass createAnnotationType(@NotNull @NonNls String name) throws IncorrectOperationException {
        return this.createTypeDefinition("@interface " + name + "{}");
    }

    @NotNull
    public PsiMethod createConstructor(@NotNull @NonNls String name) {
        return this.createConstructorFromText(name, name + "(){}", null);
    }

    @NotNull
    public PsiMethod createConstructor(@NotNull @NonNls String name, PsiElement context) {
        return this.createConstructorFromText(name, name + "(){}", context);
    }

    @NotNull
    public PsiClassType createType(@NotNull PsiClass resolve2, @NotNull PsiSubstitutor substitutor) {
        return JavaPsiFacade.getElementFactory((Project)this.myProject).createType(resolve2, substitutor);
    }

    @NotNull
    public PsiClassType createType(@NotNull PsiClass resolve2, @NotNull PsiSubstitutor substitutor, @Nullable LanguageLevel languageLevel) {
        return JavaPsiFacade.getElementFactory((Project)this.myProject).createType(resolve2, substitutor, languageLevel);
    }

    @NotNull
    public PsiClassType createType(@NotNull PsiClass aClass, PsiType parameters2) {
        return JavaPsiFacade.getElementFactory((Project)this.myProject).createType(aClass, parameters2);
    }

    @NotNull
    public PsiClassType createType(@NotNull PsiClass aClass, PsiType ... parameters2) {
        return JavaPsiFacade.getElementFactory((Project)this.myProject).createType(aClass, parameters2);
    }

    @NotNull
    public PsiSubstitutor createRawSubstitutor(@NotNull PsiTypeParameterListOwner owner) {
        return JavaPsiFacade.getElementFactory((Project)this.myProject).createRawSubstitutor(owner);
    }

    @NotNull
    public PsiSubstitutor createSubstitutor(@NotNull Map<PsiTypeParameter, PsiType> map2) {
        return JavaPsiFacade.getElementFactory((Project)this.myProject).createSubstitutor(map2);
    }

    public PsiPrimitiveType createPrimitiveType(@NotNull String text) {
        return JavaPsiFacade.getElementFactory((Project)this.myProject).createPrimitiveType(text);
    }

    @NotNull
    public PsiClassType createTypeByFQClassName(@NotNull @NonNls String qName) {
        return JavaPsiFacade.getElementFactory((Project)this.myProject).createTypeByFQClassName(qName);
    }

    @NotNull
    public PsiClassType createTypeByFQClassName(@NotNull @NonNls String qName, @NotNull GlobalSearchScope resolveScope) {
        return JavaPsiFacade.getElementFactory((Project)this.myProject).createTypeByFQClassName(qName, resolveScope);
    }

    public boolean isValidClassName(@NotNull String name) {
        return GroovyNamesUtil.isIdentifier(name);
    }

    public boolean isValidMethodName(@NotNull String name) {
        return true;
    }

    public boolean isValidParameterName(@NotNull String name) {
        return GroovyNamesUtil.isIdentifier(name);
    }

    public boolean isValidFieldName(@NotNull String name) {
        return GroovyNamesUtil.isIdentifier(name);
    }

    public boolean isValidLocalVariableName(@NotNull String name) {
        return GroovyNamesUtil.isIdentifier(name);
    }

    @NotNull
    private <T extends PsiElement> T createElementFromText(@NotNull String text, @Nullable PsiElement context, @NotNull IElementType elementType, @NotNull Class<T> elementClass) {
        GroovyDummyElement dummyElement = new GroovyDummyElement(elementType, text);
        DummyHolder holder = new DummyHolder(this.myManager, (TreeElement)dummyElement, context);
        PsiElement element = holder.getFirstChild();
        PsiElement result2 = (PsiElement)ObjectUtils.tryCast((Object)element, elementClass);
        if (result2 == null) {
            throw new IncorrectOperationException("Cannot create '" + elementClass.getName() + "' from text '" + text + "'");
        }
        GeneratedMarkerVisitor.markGenerated((PsiElement)result2);
        return (T)result2;
    }
}

