/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.documentation;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.MethodSignature;
import com.intellij.util.ArrayUtilRt;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.documentation.TypePresentation;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.transformations.impl.namedVariant.NamedParamData;
import org.jetbrains.plugins.groovy.transformations.impl.namedVariant.NamedParamsUtil;

public final class GroovyPresentationUtil {
    private static final int CONSTRAINTS_NUMBER = 2;

    public static void appendParameterPresentation(GrParameter parameter, PsiSubstitutor substitutor, TypePresentation typePresentation, StringBuilder builder) {
        if (GroovyPresentationUtil.presentNamedParameters(builder, parameter)) {
            return;
        }
        for (GrAnnotation annotation : parameter.getModifierList().getAnnotations()) {
            builder.append(annotation.getText()).append(' ');
        }
        PsiType type2 = parameter.getTypeGroovy();
        type2 = substitutor.substitute(type2);
        if (typePresentation == TypePresentation.LINK) {
            PsiImplUtil.appendTypeString(builder, type2, parameter);
            builder.append(' ').append(parameter.getName());
            return;
        }
        if (type2 != null) {
            if (typePresentation == TypePresentation.PRESENTABLE) {
                builder.append(type2.getPresentableText()).append(' ').append(parameter.getName());
            } else if (typePresentation == TypePresentation.CANONICAL) {
                builder.append(type2.getCanonicalText()).append(' ').append(parameter.getName());
            }
        } else {
            builder.append(parameter.getName());
            Set structural = Collections.synchronizedSet(new LinkedHashSet());
            ReferencesSearch.search((PsiElement)parameter, (SearchScope)parameter.getUseScope()).forEach(ref -> {
                PsiElement parent2 = ref.getElement().getParent();
                if (parent2 instanceof GrReferenceExpression) {
                    if (structural.size() >= 2) {
                        structural.add("...");
                        return false;
                    }
                    StringBuilder builder1 = new StringBuilder();
                    builder1.append(((GrReferenceElement)parent2).getReferenceName());
                    PsiType[] argTypes = PsiUtil.getArgumentTypes(parent2, true);
                    if (argTypes != null) {
                        builder1.append("(");
                        if (argTypes.length > 0) {
                            builder1.append(argTypes.length);
                            if (argTypes.length == 1) {
                                builder1.append(" arg");
                            } else {
                                builder1.append(" args");
                            }
                        }
                        builder1.append(')');
                    }
                    structural.add(builder1.toString());
                }
                return true;
            });
            if (!structural.isEmpty()) {
                builder.append(".");
                String[] array = ArrayUtilRt.toStringArray(structural);
                if (array.length > 1) {
                    builder.append("[");
                }
                for (int i = 0; i < array.length; ++i) {
                    if (i > 0) {
                        builder.append(", ");
                    }
                    builder.append(array[i]);
                }
                if (array.length > 1) {
                    builder.append("]");
                }
            }
        }
    }

    private static boolean presentNamedParameters(@NotNull StringBuilder buffer, @NotNull GrParameter parameter) {
        List<NamedParamData> pairs = NamedParamsUtil.collectNamedParams(parameter);
        StringUtil.join(pairs, namedParam -> namedParam.getName() + ": " + namedParam.getType().getPresentableText(), (String)", ", (StringBuilder)buffer);
        return !pairs.isEmpty();
    }

    public static String getSignaturePresentation(MethodSignature signature) {
        PsiType[] types;
        StringBuilder builder = new StringBuilder();
        builder.append(signature.getName()).append('(');
        for (PsiType type2 : types = signature.getParameterTypes()) {
            builder.append(type2.getPresentableText()).append(", ");
        }
        if (types.length > 0) {
            builder.delete(builder.length() - 2, builder.length());
        }
        builder.append(")");
        return builder.toString();
    }
}

