/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion.weighers;

import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.proximity.ReferenceListWeigher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrReferenceList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;

public class GrReferenceListWeigher
extends ReferenceListWeigher {
    private static final PsiElementPattern.Capture<PsiElement> INSIDE_REFERENCE_LIST = (PsiElementPattern.Capture)PlatformPatterns.psiElement().withParents(new Class[]{GrCodeReferenceElement.class, GrReferenceList.class});

    protected ReferenceListWeigher.Preference getPreferredCondition(@NotNull PsiElement position) {
        if (INSIDE_REFERENCE_LIST.accepts((Object)position)) {
            GrReferenceList list = (GrReferenceList)position.getParent().getParent();
            PsiElement parent2 = list.getParent();
            if (parent2 instanceof GrTypeDefinition) {
                GrTypeDefinition cls = (GrTypeDefinition)parent2;
                if (cls.isInterface() && list == cls.getExtendsClause() || list == cls.getImplementsClause()) {
                    return ReferenceListWeigher.Preference.Interfaces;
                }
                if (list == cls.getExtendsClause()) {
                    return ReferenceListWeigher.Preference.Classes;
                }
            }
            if (parent2 instanceof GrMethod && ((GrMethod)parent2).getThrowsList() == list) {
                return ReferenceListWeigher.Preference.Exceptions;
            }
        }
        return null;
    }
}

