/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion;

import com.intellij.codeInsight.completion.JavaClassNameCompletionContributor;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.Consumer;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmName;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.completion.CompleteReferenceProcessor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.packaging.GrPackageDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeParameterList;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiTreeUtilKt;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.GrCodeReferenceResolverKt;
import org.jetbrains.plugins.groovy.lang.resolve.ReferencesKt;
import org.jetbrains.plugins.groovy.lang.resolve.processors.GrDelegatingScopeProcessorWithHints;
import org.jetbrains.plugins.groovy.lang.resolve.processors.GroovyResolveKind;
import org.jetbrains.plugins.groovy.lang.resolve.processors.StaticMembersFilteringProcessor;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000@\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a$\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0010\u0010\u0005\u001a\f\u0012\u0004\u0012\u00020\u00070\u0006j\u0002`\b\u001a\u000e\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u0002H\u0002\u001a\u000e\u0010\u000b\u001a\u0004\u0018\u00010\f*\u00020\u0002H\u0002\u001a\u000e\u0010\r\u001a\u00020\u000e*\u0004\u0018\u00010\u000fH\u0002\u001a\u0014\u0010\u0010\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\u0014\u0010\u0013\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\u0014\u0010\u0014\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0002*\u0018\b\u0002\u0010\u0015\"\b\u0012\u0004\u0012\u00020\u00070\u00062\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a8\u0006\u0016"}, d2={"complete", "", "Lorg/jetbrains/plugins/groovy/lang/psi/api/types/GrCodeReferenceElement;", "matcher", "Lcom/intellij/codeInsight/completion/PrefixMatcher;", "consumer", "Lcom/intellij/util/Consumer;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "Lorg/jetbrains/plugins/groovy/lang/completion/LookupConsumer;", "findTypeParameterListCandidate", "Lorg/jetbrains/plugins/groovy/lang/psi/api/types/GrTypeParameterList;", "getRootTypeElement", "Lorg/jetbrains/plugins/groovy/lang/psi/api/types/GrTypeElement;", "isTypeElementChild", "", "Lcom/intellij/psi/PsiElement;", "processClassDeclarations", "processor", "Lcom/intellij/psi/scope/PsiScopeProcessor;", "processPackageDeclarations", "processTypeParameters", "LookupConsumer", "intellij.groovy"})
@JvmName(name="CompleteCodeReferenceElement")
public final class CompleteCodeReferenceElement {
    public static final void complete(@NotNull GrCodeReferenceElement $this$complete, @NotNull PrefixMatcher matcher, @NotNull Consumer<LookupElement> consumer) {
        PsiElement parent2 = $this$complete.getParent();
        boolean afterNew = JavaClassNameCompletionContributor.AFTER_NEW.accepts((Object)$this$complete);
        CompleteReferenceProcessor processor = new CompleteReferenceProcessor(matcher, consumer, afterNew);
        if (parent2 instanceof GrImportStatement) {
            if (((GrImportStatement)parent2).isStatic()) {
                CompleteCodeReferenceElement.processClassDeclarations($this$complete, processor);
            }
            CompleteCodeReferenceElement.processPackageDeclarations($this$complete, new GrDelegatingScopeProcessorWithHints((PsiScopeProcessor)processor, ElementClassHint.DeclarationKind.CLASS, ElementClassHint.DeclarationKind.PACKAGE));
            return;
        }
        GrDelegatingScopeProcessorWithHints packageProcessor = new GrDelegatingScopeProcessorWithHints((PsiScopeProcessor)processor, ElementClassHint.DeclarationKind.PACKAGE, new ElementClassHint.DeclarationKind[0]);
        if (parent2 instanceof GrPackageDefinition) {
            CompleteCodeReferenceElement.processPackageDeclarations($this$complete, packageProcessor);
            return;
        }
        CompleteCodeReferenceElement.processTypeParameters($this$complete, processor);
        GrDelegatingScopeProcessorWithHints classProcessor = new GrDelegatingScopeProcessorWithHints((PsiScopeProcessor)processor, ElementClassHint.DeclarationKind.CLASS, new ElementClassHint.DeclarationKind[0]);
        GrCodeReferenceResolverKt.processClasses($this$complete, classProcessor, ResolveState.initial());
        if ($this$complete.getQualifier() != null) {
            CompleteCodeReferenceElement.processPackageDeclarations($this$complete, classProcessor);
        }
        CompleteCodeReferenceElement.processPackageDeclarations($this$complete, packageProcessor);
    }

    private static final void processPackageDeclarations(GrCodeReferenceElement $this$processPackageDeclarations, PsiScopeProcessor processor) {
        String string;
        GrCodeReferenceElement qualifier = (GrCodeReferenceElement)$this$processPackageDeclarations.getQualifier();
        if (qualifier == null) {
            string = "";
        } else {
            string = qualifier.getQualifiedReferenceName();
            if (string == null) {
                return;
            }
        }
        String qualifierFqn = string;
        PsiPackage psiPackage = JavaPsiFacade.getInstance((Project)$this$processPackageDeclarations.getProject()).findPackage(qualifierFqn);
        if (psiPackage == null) {
            return;
        }
        PsiPackage parentPackage = psiPackage;
        parentPackage.processDeclarations(processor, ResolveState.initial(), null, (PsiElement)$this$processPackageDeclarations);
    }

    private static final void processClassDeclarations(GrCodeReferenceElement $this$processClassDeclarations, PsiScopeProcessor processor) {
        GrCodeReferenceElement grCodeReferenceElement = (GrCodeReferenceElement)$this$processClassDeclarations.getQualifier();
        if (grCodeReferenceElement == null) {
            return;
        }
        GrCodeReferenceElement qualifier = grCodeReferenceElement;
        PsiClass psiClass = ReferencesKt.resolveClassFqn(qualifier);
        if (psiClass == null) {
            return;
        }
        PsiClass clazz = psiClass;
        clazz.processDeclarations((PsiScopeProcessor)new StaticMembersFilteringProcessor(processor, null), ResolveState.initial(), null, (PsiElement)$this$processClassDeclarations);
    }

    private static final void processTypeParameters(GrCodeReferenceElement $this$processTypeParameters, PsiScopeProcessor processor) {
        GroovyResolveKind.Hint typeParameterProcessor2 = new GroovyResolveKind.Hint(processor, processor, SetsKt.emptySet()){
            final /* synthetic */ PsiScopeProcessor $processor;

            @Nullable
            public <T> T getHint(@NotNull Key<T> hintKey) {
                return (T)(hintKey == GroovyResolveKind.HINT_KEY ? (Object)this : super.getHint(hintKey));
            }

            public boolean shouldProcess(@NotNull GroovyResolveKind kind) {
                return kind == GroovyResolveKind.TYPE_PARAMETER;
            }
            {
                this.$processor = $captured_local_variable$0;
                super($super_call_param$1, (Set<ElementClassHint.DeclarationKind>)$super_call_param$2);
            }
        };
        GrTypeParameterList grTypeParameterList = CompleteCodeReferenceElement.findTypeParameterListCandidate($this$processTypeParameters);
        if (grTypeParameterList != null) {
            grTypeParameterList.processDeclarations((PsiScopeProcessor)typeParameterProcessor2, ResolveState.initial(), null, $this$processTypeParameters);
        }
        PsiTreeUtilKt.treeWalkUp$default($this$processTypeParameters, (PsiScopeProcessor)typeParameterProcessor2, ResolveState.initial(), null, 4, null);
    }

    private static final GrTypeParameterList findTypeParameterListCandidate(GrCodeReferenceElement $this$findTypeParameterListCandidate) {
        GrTypeParameterList grTypeParameterList;
        PsiElement parent2;
        GrTypeElement grTypeElement = CompleteCodeReferenceElement.getRootTypeElement($this$findTypeParameterListCandidate);
        if (grTypeElement == null) {
            return null;
        }
        GrTypeElement typeElement = grTypeElement;
        PsiElement psiElement = parent2 = typeElement.getParent();
        if (psiElement instanceof GrTypeDefinitionBody) {
            PsiElement psiElement2 = PsiUtil.skipWhitespacesAndComments(typeElement.getPrevSibling(), false);
            if (!(psiElement2 instanceof GrTypeParameterList)) {
                psiElement2 = null;
            }
            grTypeParameterList = (GrTypeParameterList)psiElement2;
        } else if (psiElement instanceof GrVariableDeclaration) {
            PsiErrorElement errorElement;
            PsiElement psiElement3 = PsiUtil.skipWhitespacesAndComments(typeElement.getPrevSibling(), false);
            if (!(psiElement3 instanceof PsiErrorElement)) {
                psiElement3 = null;
            }
            PsiErrorElement psiErrorElement = errorElement = (PsiErrorElement)psiElement3;
            Object object = psiErrorElement != null ? psiErrorElement.getFirstChild() : null;
            if (!(object instanceof GrTypeParameterList)) {
                object = null;
            }
            grTypeParameterList = (GrTypeParameterList)object;
        } else {
            grTypeParameterList = null;
        }
        return grTypeParameterList;
    }

    private static final GrTypeElement getRootTypeElement(GrCodeReferenceElement $this$getRootTypeElement) {
        PsiElement current = $this$getRootTypeElement.getParent();
        while (CompleteCodeReferenceElement.isTypeElementChild(current)) {
            PsiElement parent2;
            PsiElement psiElement = current;
            Object object = parent2 = psiElement != null ? psiElement.getParent() : null;
            if (current instanceof GrTypeElement && !CompleteCodeReferenceElement.isTypeElementChild(parent2)) {
                return (GrTypeElement)current;
            }
            current = parent2;
        }
        return null;
    }

    private static final boolean isTypeElementChild(PsiElement $this$isTypeElementChild) {
        return $this$isTypeElementChild instanceof GrCodeReferenceElement || $this$isTypeElementChild instanceof GrTypeArgumentList || $this$isTypeElementChild instanceof GrTypeElement;
    }
}

