/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.gant;

import com.intellij.lang.Language;
import com.intellij.lang.ant.AntIntrospector;
import com.intellij.lang.ant.dom.AntDomExtender;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import icons.AntIcons;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightParameter;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtilKt;

class AntBuilderMethod
extends LightMethodBuilder {
    @NotNull
    private final PsiFile myFile;
    @Nullable
    private final Class<?> myAntClass;

    AntBuilderMethod(@NotNull PsiFile file, @NotNull String name, @Nullable Class<?> antClass) {
        super(file.getManager(), (Language)GroovyLanguage.INSTANCE, name);
        this.myFile = file;
        this.myAntClass = antClass;
        this.setModifiers(new String[]{"public"});
        this.setBaseIcon(AntIcons.Task);
        this.setMethodReturnType(() -> PsiType.getJavaLangObject((PsiManager)this.getManager(), (GlobalSearchScope)this.getResolveScope()));
    }

    @NotNull
    public PsiElement getNavigationElement() {
        PsiClass psiClass;
        if (this.myAntClass != null && (psiClass = JavaPsiFacade.getInstance((Project)this.getProject()).findClass(this.myAntClass.getName(), this.myFile.getResolveScope())) != null) {
            return psiClass;
        }
        return this;
    }

    public boolean processNestedElements(PsiScopeProcessor processor) {
        if (!ResolveUtilKt.shouldProcessMethods(processor)) {
            return true;
        }
        AntIntrospector introspector = AntDomExtender.getIntrospector(this.myAntClass);
        if (introspector == null) {
            return true;
        }
        String expectedName = ResolveUtil.getNameHint(processor);
        PsiClassType mapType = TypesUtil.createType("java.util.LinkedHashMap", (PsiElement)this.myFile);
        PsiClassType stringType = TypesUtil.createType("java.lang.String", (PsiElement)this.myFile);
        PsiClassType closureType = TypesUtil.createType("groovy.lang.Closure", (PsiElement)this.myFile);
        for (String name : Collections.list(introspector.getNestedElements())) {
            if (expectedName != null && !expectedName.equals(name)) continue;
            Class antClass = introspector.getElementType(name);
            for (LightMethodBuilder method : AntBuilderMethod.methods(this.myFile, name, antClass, (PsiType)mapType, (PsiType)stringType, (PsiType)closureType)) {
                if (processor.execute((PsiElement)method, ResolveState.initial())) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    static List<LightMethodBuilder> methods(@NotNull PsiFile file, @NotNull String name, @Nullable Class<?> antClass, @NotNull PsiType mapType, @NotNull PsiType stringType, @NotNull PsiType closureType) {
        AntBuilderMethod method = new AntBuilderMethod(file, name, antClass);
        method.addParameter(new GrLightParameter("args", mapType, (PsiElement)method));
        method.addParameter(new GrLightParameter("singleArg", stringType, (PsiElement)method));
        method.addParameter(new GrLightParameter("body", closureType, (PsiElement)method).setOptional(true));
        AntBuilderMethod method2 = new AntBuilderMethod(file, name, antClass);
        method2.addParameter(new GrLightParameter("args", mapType, (PsiElement)method2));
        method2.addParameter(new GrLightParameter("body", closureType, (PsiElement)method2).setOptional(true));
        AntBuilderMethod method3 = new AntBuilderMethod(file, name, antClass);
        method3.addParameter(new GrLightParameter("singleArg", stringType, (PsiElement)method3));
        method3.addParameter(new GrLightParameter("body", closureType, (PsiElement)method3).setOptional(true));
        AntBuilderMethod method4 = new AntBuilderMethod(file, name, antClass);
        method4.addParameter(new GrLightParameter("body", closureType, (PsiElement)method4).setOptional(true));
        return Arrays.asList(new LightMethodBuilder[]{method, method2, method3, method4});
    }
}

