/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.dgm;

import com.intellij.codeInsight.completion.AllClassesGetter;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.properties.parsing.PropertiesTokenTypes;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ProcessingContext;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.dgm.DGMUtil;
import org.jetbrains.plugins.groovy.lang.completion.GroovyCompletionUtil;

public class DGMCompletionContributor
extends CompletionContributor {
    public DGMCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement((IElementType)PropertiesTokenTypes.KEY_CHARACTERS), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters2, @NotNull ProcessingContext context, @NotNull CompletionResultSet result2) {
                PsiElement position = parameters2.getPosition();
                if (!DGMUtil.isInDGMFile(position)) {
                    return;
                }
                Map map2 = ((PropertiesFile)position.getContainingFile()).getNamesMap();
                for (String key : DGMUtil.KEYS) {
                    if (map2.containsKey(key)) continue;
                    result2.addElement((LookupElement)LookupElementBuilder.create((String)key));
                }
            }
        });
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement((IElementType)PropertiesTokenTypes.VALUE_CHARACTERS), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters2, @NotNull ProcessingContext context, @NotNull CompletionResultSet result2) {
                PsiElement position = parameters2.getPosition();
                if (!DGMUtil.isInDGMFile(position)) {
                    return;
                }
                AllClassesGetter.processJavaClasses((CompletionParameters)parameters2, (PrefixMatcher)result2.getPrefixMatcher(), (boolean)true, aClass -> result2.addElement(GroovyCompletionUtil.createClassLookupItem(aClass)));
            }
        });
    }
}

