/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions.dynamic;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.DynamicToolWindowWrapper;

public class RemoveDynamicAction
extends AnAction {
    public RemoveDynamicAction() {
        super("Remove", "Remove dynamic element", AllIcons.General.Remove);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DynamicToolWindowWrapper toolWindow = DynamicToolWindowWrapper.getInstance(e.getProject());
        toolWindow.deleteRow();
    }

    public void update(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        TreePath[] paths = DynamicToolWindowWrapper.getInstance(project).getTreeTable().getTree().getSelectionPaths();
        e.getPresentation().setEnabled(paths != null);
    }
}

