/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.checkers;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.annotator.checkers.CustomAnnotationChecker;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationNameValuePair;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;

public class TypeCheckedAnnotationChecker
extends CustomAnnotationChecker {
    @Override
    public boolean checkArgumentList(@NotNull AnnotationHolder holder, @NotNull GrAnnotation annotation) {
        GrCodeReferenceElement classReference = annotation.getClassReference();
        PsiElement resolved = classReference.resolve();
        if (!(resolved instanceof PsiClass) || !"groovy.transform.TypeChecked".equals(((PsiClass)resolved).getQualifiedName())) {
            return false;
        }
        String sdkVersion = GroovyConfigUtils.getInstance().getSDKVersion(annotation);
        if (!"2.1".equals(sdkVersion) && !"2.1.0".equals(sdkVersion)) {
            return false;
        }
        GrAnnotationNameValuePair[] attributes = annotation.getParameterList().getAttributes();
        Pair<PsiElement, String> r = TypeCheckedAnnotationChecker.checkAnnotationArguments((PsiClass)resolved, attributes, false);
        if (r != null && r.getFirst() != null) {
            holder.newAnnotation(HighlightSeverity.ERROR, (String)r.getSecond()).range((PsiElement)r.getFirst()).create();
        }
        return true;
    }
}

