/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.annotator.VisitorCallback;
import org.jetbrains.plugins.groovy.codeInspection.bugs.GrAccessibilityChecker;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;

public class InaccessibleElementVisitor
extends GroovyRecursiveElementVisitor {
    private final GrAccessibilityChecker myReferenceChecker;
    private final VisitorCallback myCallback;
    private int myTriggerCounter = 0;

    public InaccessibleElementVisitor(GroovyFileBase file, Project project, VisitorCallback callback) {
        this.myCallback = callback;
        this.myReferenceChecker = new GrAccessibilityChecker(file, project);
    }

    @Override
    public void visitReferenceExpression(@NotNull GrReferenceExpression referenceExpression) {
        HighlightInfo info;
        int oldValue = this.myTriggerCounter;
        super.visitReferenceExpression(referenceExpression);
        if (oldValue == this.myTriggerCounter && (info = this.myReferenceChecker.checkReferenceExpression(referenceExpression)) != null) {
            this.myCallback.trigger(referenceExpression, info);
            ++this.myTriggerCounter;
        }
    }

    @Override
    public void visitCodeReferenceElement(@NotNull GrCodeReferenceElement refElement) {
        HighlightInfo info;
        int oldValue = this.myTriggerCounter;
        super.visitCodeReferenceElement(refElement);
        if (oldValue == this.myTriggerCounter && (info = this.myReferenceChecker.checkCodeReferenceElement(refElement)) != null) {
            this.myCallback.trigger(refElement, info);
            ++this.myTriggerCounter;
        }
    }
}

