/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;

public class UnsafeNativeCodeDetector
extends Detector
implements SourceCodeScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(UnsafeNativeCodeDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue LOAD = Issue.create("UnsafeDynamicallyLoadedCode", "`load` used to dynamically load code", "Dynamically loading code from locations other than the application's library directory or the Android platform's built-in library directories is dangerous, as there is an increased risk that the code could have been tampered with. Applications should use `loadLibrary` when possible, which provides increased assurance that libraries are loaded from one of these safer locations. Application developers should use the features of their development environment to place application native libraries into the lib directory of their compiled APKs.", Category.SECURITY, 4, Severity.WARNING, IMPLEMENTATION).setAndroidSpecific(true);
    public static final Issue UNSAFE_NATIVE_CODE_LOCATION = Issue.create("UnsafeNativeCodeLocation", "Native code outside library directory", "In general, application native code should only be placed in the application's library directory, not in other locations such as the res or assets directories. Placing the code in the library directory provides increased assurance that the code will not be tampered with after application installation. Application developers should use the features of their development environment to place application native libraries into the lib directory of their compiled APKs. Embedding non-shared library native executables into applications should be avoided when possible.", Category.SECURITY, 4, Severity.WARNING, IMPLEMENTATION).setAndroidSpecific(true);
    private static final String RUNTIME_CLASS = "java.lang.Runtime";
    private static final String SYSTEM_CLASS = "java.lang.System";
    private static final byte[] ELF_MAGIC_VALUE = new byte[]{127, 69, 76, 70};

    @Override
    public List<String> getApplicableMethodNames() {
        return Collections.singletonList("load");
    }

    @Override
    public void visitMethodCall(JavaContext context2, UCallExpression call, PsiMethod method) {
        JavaEvaluator evaluator;
        if ("load".equals(method.getName()) && ((evaluator = context2.getEvaluator()).isMemberInSubClassOf((PsiMember)method, RUNTIME_CLASS, false) || evaluator.isMemberInSubClassOf((PsiMember)method, SYSTEM_CLASS, false))) {
            context2.report(LOAD, (UElement)call, context2.getLocation((UElement)call), "Dynamically loading code using `load` is risky, please use `loadLibrary` instead when possible");
        }
    }

    @Override
    public void afterCheckEachProject(Context context2) {
        if (!context2.getProject().getReportIssues()) {
            return;
        }
        UnsafeNativeCodeDetector.checkResourceFolders(context2, context2.getProject());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isNativeCode(File file) {
        if (!file.isFile()) {
            return false;
        }
        try (FileInputStream fis = new FileInputStream(file);){
            byte[] bytes = new byte[4];
            int length = fis.read(bytes);
            boolean bl = length == 4 && Arrays.equals(ELF_MAGIC_VALUE, bytes);
            return bl;
        }
        catch (IOException ex) {
            return false;
        }
    }

    private static void checkResourceFolders(Context context2, Project project) {
        if (!context2.getScope().contains((Object)Scope.RESOURCE_FOLDER)) {
            return;
        }
        List<File> resourceFolders = project.getResourceFolders();
        for (File res : resourceFolders) {
            File[] folders = res.listFiles();
            if (folders == null) continue;
            for (File typeFolder : folders) {
                File[] rawFiles;
                if (!typeFolder.getName().startsWith("raw") || (rawFiles = typeFolder.listFiles()) == null) continue;
                for (File rawFile : rawFiles) {
                    UnsafeNativeCodeDetector.checkFile(context2, rawFile);
                }
            }
        }
        List<File> assetFolders = project.getAssetFolders();
        for (File assetFolder : assetFolders) {
            File[] assets = assetFolder.listFiles();
            if (assets == null) continue;
            for (File asset : assets) {
                UnsafeNativeCodeDetector.checkFile(context2, asset);
            }
        }
    }

    private static void checkFile(Context context2, File file) {
        if (UnsafeNativeCodeDetector.isNativeCode(file)) {
            if (Lint.endsWith(file.getPath(), ".so")) {
                context2.report(UNSAFE_NATIVE_CODE_LOCATION, Location.create(file), "Shared libraries should not be placed in the res or assets directories. Please use the features of your development environment to place shared libraries in the lib directory of the compiled APK.");
            } else {
                context2.report(UNSAFE_NATIVE_CODE_LOCATION, Location.create(file), "Embedding non-shared library native executables into applications should be avoided when possible, as there is an increased risk that the executables could be tampered with after installation. Instead, native code should be placed in a shared library, and the features of the development environment should be used to place the shared library in the lib directory of the compiled APK.");
            }
        }
    }
}

