/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.ClassScanner;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class SecureRandomGeneratorDetector
extends Detector
implements ClassScanner {
    private static final String OWNER_SECURE_RANDOM = "java/security/SecureRandom";
    private static final String BLOG_URL = "https://android-developers.blogspot.com/2013/08/some-securerandom-thoughts.html";
    public static final Issue ISSUE = Issue.create("TrulyRandom", "Weak RNG", "Key generation, signing, encryption, and random number generation may not receive cryptographically strong values due to improper initialization of the underlying PRNG on Android 4.3 and below.\n\nIf your application relies on cryptographically secure random number generation you should apply the workaround described in https://android-developers.blogspot.com/2013/08/some-securerandom-thoughts.html .\n\nThis lint rule is mostly informational; it does not accurately detect whether cryptographically secure RNG is required, or whether the workaround has already been applied. After reading the blog entry and updating your code if necessary, you can disable this lint issue.", Category.SECURITY, 9, Severity.WARNING, new Implementation(SecureRandomGeneratorDetector.class, Scope.CLASS_FILE_SCOPE)).addMoreInfo("https://android-developers.blogspot.com/2013/08/some-securerandom-thoughts.html");
    private static final String WRAP = "wrap";
    private static final String UNWRAP = "unwrap";
    private static final String INIT = "init";
    private static final String INIT_SIGN = "initSign";
    private static final String GET_INSTANCE = "getInstance";
    private static final String FOR_NAME = "forName";
    private static final String JAVA_LANG_CLASS = "java/lang/Class";
    private static final String JAVAX_CRYPTO_KEY_GENERATOR = "javax/crypto/KeyGenerator";
    private static final String JAVAX_CRYPTO_KEY_AGREEMENT = "javax/crypto/KeyAgreement";
    private static final String JAVA_SECURITY_KEY_PAIR_GENERATOR = "java/security/KeyPairGenerator";
    private static final String JAVAX_CRYPTO_SIGNATURE = "javax/crypto/Signature";
    private static final String JAVAX_CRYPTO_CIPHER = "javax/crypto/Cipher";
    private static final String JAVAX_NET_SSL_SSLENGINE = "javax/net/ssl/SSLEngine";
    private Location mLocation;
    private boolean mIgnore;

    @Override
    public List<String> getApplicableCallOwners() {
        return Arrays.asList(JAVAX_CRYPTO_KEY_GENERATOR, JAVA_SECURITY_KEY_PAIR_GENERATOR, JAVAX_CRYPTO_KEY_AGREEMENT, OWNER_SECURE_RANDOM, JAVAX_NET_SSL_SSLENGINE, JAVAX_CRYPTO_SIGNATURE, JAVAX_CRYPTO_CIPHER);
    }

    @Override
    public List<String> getApplicableCallNames() {
        return Collections.singletonList(FOR_NAME);
    }

    @Override
    public void checkCall(ClassContext context2, ClassNode classNode, MethodNode method, MethodInsnNode call) {
        if (this.mIgnore) {
            return;
        }
        String owner = call.owner;
        String name = call.name;
        if (name.equals(FOR_NAME)) {
            Object cst;
            if (call.getOpcode() != 184 || !owner.equals(JAVA_LANG_CLASS)) {
                return;
            }
            AbstractInsnNode prev = Lint.getPrevInstruction((AbstractInsnNode)call);
            if (prev instanceof LdcInsnNode && (cst = ((LdcInsnNode)prev).cst) instanceof String && "org.apache.harmony.xnet.provider.jsse.NativeCrypto".equals(cst)) {
                this.mIgnore = true;
            }
            return;
        }
        assert (owner.equals(JAVAX_CRYPTO_KEY_GENERATOR) || owner.equals(JAVA_SECURITY_KEY_PAIR_GENERATOR) || owner.equals(JAVAX_CRYPTO_KEY_AGREEMENT) || owner.equals(OWNER_SECURE_RANDOM) || owner.equals(JAVAX_CRYPTO_CIPHER) || owner.equals(JAVAX_CRYPTO_SIGNATURE) || owner.equals(JAVAX_NET_SSL_SSLENGINE)) : owner;
        boolean warn = false;
        if (owner.equals(JAVAX_CRYPTO_SIGNATURE)) {
            warn = name.equals(INIT_SIGN);
        } else if (owner.equals(JAVAX_CRYPTO_CIPHER)) {
            if (name.equals(INIT)) {
                int opcode;
                int arity = SecureRandomGeneratorDetector.getDescArity(call.desc);
                MethodInsnNode node = call;
                for (int i = 0; i < arity && (node = Lint.getPrevInstruction((AbstractInsnNode)node)) != null; ++i) {
                }
                if (node != null && ((opcode = node.getOpcode()) == 6 || opcode == 4)) {
                    warn = true;
                }
            }
        } else if (name.equals(GET_INSTANCE) || name.equals("<init>") || name.equals(WRAP) || name.equals(UNWRAP)) {
            warn = true;
        }
        if (warn) {
            if (this.mLocation != null) {
                return;
            }
            if (context2.getMainProject().getMinSdk() > 18) {
                this.mIgnore = true;
                return;
            }
            if (context2.getDriver().isSuppressed(ISSUE, classNode, method, (AbstractInsnNode)call)) {
                this.mIgnore = true;
            } else {
                this.mLocation = context2.getLocation((AbstractInsnNode)call);
            }
        }
    }

    @VisibleForTesting
    static int getDescArity(String desc) {
        char c;
        int arity = 0;
        int max = desc.length();
        for (int i = 1; i < max && (c = desc.charAt(i)) != ')'; ++i) {
            if (c == 'L') {
                ++arity;
                i = desc.indexOf(59, i);
                assert (i != -1) : desc;
                continue;
            }
            ++arity;
        }
        return arity;
    }

    @Override
    public void afterCheckRootProject(Context context2) {
        if (this.mLocation != null && !this.mIgnore) {
            String message2 = "Potentially insecure random numbers on Android 4.3 and older. Read https://android-developers.blogspot.com/2013/08/some-securerandom-thoughts.html for more info.";
            context2.report(ISSUE, this.mLocation, message2);
        }
    }
}

