/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Collection;
import java.util.Collections;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MissingIdDetector
extends LayoutDetector {
    public static final Issue ISSUE = Issue.create("MissingId", "Fragments should specify an `id` or `tag`", "If you do not specify an `android:id` or an `android:tag` attribute on a `<fragment>` element, then if the activity is restarted (for example for an orientation rotation) you may lose state. From the fragment documentation:\n\n\"Each fragment requires a unique identifier that the system can use to restore the fragment if the activity is restarted (and which you can use to capture the fragment to perform transactions, such as remove it).\n\n* Supply the `android:id` attribute with a unique ID.\n* Supply the `android:tag` attribute with a unique string.\nIf you provide neither of the previous two, the system uses the ID of the container view.", Category.CORRECTNESS, 5, Severity.WARNING, new Implementation(MissingIdDetector.class, Scope.RESOURCE_FILE_SCOPE)).addMoreInfo("https://developer.android.com/guide/components/fragments.html");

    @Override
    public Collection<String> getApplicableElements() {
        return Collections.singletonList("fragment");
    }

    @Override
    public void visitElement(XmlContext context2, Element element) {
        if (!element.hasAttributeNS("http://schemas.android.com/apk/res/android", "id") && !element.hasAttributeNS("http://schemas.android.com/apk/res/android", "tag")) {
            LintFix fix = this.fix().set().todo("http://schemas.android.com/apk/res/android", "id", "@+id/", null).build();
            context2.report(ISSUE, (Node)element, context2.getNameLocation(element), "This `<fragment>` tag should specify an id or a tag to preserve state across activity restarts", fix);
        }
    }
}

