/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.resources.ResourceFolderType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.DefaultPosition;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/lint/checks/ExtraTextDetector;", "Lcom/android/tools/lint/detector/api/ResourceXmlDetector;", "()V", "foundText", "", "appliesTo", "folderType", "Lcom/android/resources/ResourceFolderType;", "visitDocument", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "document", "Lorg/w3c/dom/Document;", "visitNode", "node", "Lorg/w3c/dom/Node;", "Issues", "android.sdktools.lint-checks"})
public final class ExtraTextDetector
extends ResourceXmlDetector {
    private boolean foundText;
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    public static final Issues Issues;

    @Override
    public boolean appliesTo(@NotNull ResourceFolderType folderType) {
        return folderType == ResourceFolderType.LAYOUT || folderType == ResourceFolderType.MENU || folderType == ResourceFolderType.ANIM || folderType == ResourceFolderType.ANIMATOR || folderType == ResourceFolderType.DRAWABLE || folderType == ResourceFolderType.COLOR || folderType == ResourceFolderType.NAVIGATION;
    }

    @Override
    public void visitDocument(@NotNull XmlContext context2, @NotNull Document document) {
        this.foundText = false;
        this.visitNode(context2, document);
    }

    /*
     * WARNING - void declaration
     */
    private final void visitNode(XmlContext context2, Node node) {
        int i;
        int n;
        short nodeType = node.getNodeType();
        if (nodeType == 3 && !this.foundText) {
            String text = node.getNodeValue();
            n = text.length();
            for (i = 0; i < n; ++i) {
                Position start;
                char c = text.charAt(i);
                if (Character.isWhitespace(c)) continue;
                String $this$trim$iv = text;
                boolean $i$f$trim3 = false;
                CharSequence $this$trim$iv$iv2 = $this$trim$iv;
                boolean $i$f$trim2 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv2.length() - 1;
                int startFound$iv$iv = 0;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = startFound$iv$iv == 0 ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $this$trim$iv$iv2.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (startFound$iv$iv == 0) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = 1;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                String snippet = ((Object)$this$trim$iv$iv2.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                int maxLength = 100;
                if (snippet.length() > maxLength) {
                    StringBuilder stringBuilder = new StringBuilder();
                    String $i$f$trim3 = snippet;
                    int $this$trim$iv$iv2 = 0;
                    $i$f$trim2 = false;
                    String string = $i$f$trim3;
                    if (string == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string2 = string.substring($this$trim$iv$iv2, maxLength);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    snippet = stringBuilder.append(string2).append("...").toString();
                }
                Location location = context2.getLocation(node);
                if (i > 0 && (start = location.getStart()) != null) {
                    int line = start.getLine();
                    int column = start.getColumn();
                    int offset = start.getOffset();
                    startFound$iv$iv = 0;
                    int n2 = i;
                    while (startFound$iv$iv < n2) {
                        void j;
                        ++offset;
                        if (text.charAt((int)j) == '\n') {
                            if (line != -1) {
                                ++line;
                            }
                            if (column != -1) {
                                column = 0;
                            }
                        } else if (column != -1) {
                            ++column;
                        }
                        ++j;
                    }
                    start = new DefaultPosition(line, column, offset);
                    location = Location.Companion.create(context2.file, start, location.getEnd());
                }
                XmlContext.report$default(context2, ISSUE, node, location, "Unexpected text found in layout file: \"" + snippet + '\"', null, 16, null);
                this.foundText = true;
                break;
            }
        }
        NodeList childNodes = node.getChildNodes();
        n = childNodes.getLength();
        for (i = 0; i < n; ++i) {
            Node child = childNodes.item(i);
            this.visitNode(context2, child);
        }
    }

    static {
        Issues = new Issues(null);
        ISSUE = Issue.Companion.create("ExtraText", "Extraneous text in resource files", "\n            Layout resource files should only contain elements and attributes. Any XML text content found \\\n            in the file is likely accidental (and potentially dangerous if the text resembles XML and the \\\n            developer believes the text to be functional)", Category.CORRECTNESS, 3, Severity.WARNING, new Implementation(ExtraTextDetector.class, Scope.MANIFEST_AND_RESOURCE_SCOPE, Scope.RESOURCE_FILE_SCOPE, Scope.MANIFEST_SCOPE));
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/lint/checks/ExtraTextDetector$Issues;", "", "()V", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "android.sdktools.lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

