/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.AbstractAnnotationDetector;
import com.android.tools.lint.checks.AnnotationDetector;
import com.android.tools.lint.detector.api.AnnotationUsageType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UClassInitializer;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001c2\u00020\u00012\u00020\u0002:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016JD\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u00052\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u0005H\u0002J|\u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00100\u00052\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u00052\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u00052\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00100\u0005H\u0016\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/lint/checks/CheckResultDetector;", "Lcom/android/tools/lint/checks/AbstractAnnotationDetector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "applicableAnnotations", "", "", "checkResult", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "element", "Lorg/jetbrains/uast/UElement;", "method", "Lcom/intellij/psi/PsiMethod;", "annotation", "Lorg/jetbrains/uast/UAnnotation;", "allMemberAnnotations", "allClassAnnotations", "visitAnnotationUsage", "usage", "type", "Lcom/android/tools/lint/detector/api/AnnotationUsageType;", "qualifiedName", "referenced", "Lcom/intellij/psi/PsiElement;", "annotations", "allPackageAnnotations", "Companion", "android.sdktools.lint-checks"})
public final class CheckResultDetector
extends AbstractAnnotationDetector
implements SourceCodeScanner {
    private static final Implementation IMPLEMENTATION;
    @JvmField
    @NotNull
    public static final Issue CHECK_RESULT;
    @JvmField
    @NotNull
    public static final Issue CHECK_PERMISSION;
    public static final Companion Companion;

    @Override
    @NotNull
    public List<String> applicableAnnotations() {
        return CollectionsKt.listOf((Object[])new String[]{AnnotationDetector.CHECK_RESULT_ANNOTATION.oldName(), AnnotationDetector.CHECK_RESULT_ANNOTATION.newName(), "edu.umd.cs.findbugs.annotations.CheckReturnValue", "javax.annotation.CheckReturnValue", "com.google.errorprone.annotations.CanIgnoreReturnValue", "io.reactivex.annotations.CheckReturnValue", "com.google.errorprone.annotations.CheckReturnValue"});
    }

    @Override
    public void visitAnnotationUsage(@NotNull JavaContext context2, @NotNull UElement usage, @NotNull AnnotationUsageType type, @NotNull UAnnotation annotation, @NotNull String qualifiedName, @Nullable PsiMethod method, @Nullable PsiElement referenced, @NotNull List<? extends UAnnotation> annotations, @NotNull List<? extends UAnnotation> allMemberAnnotations, @NotNull List<? extends UAnnotation> allClassAnnotations, @NotNull List<? extends UAnnotation> allPackageAnnotations) {
        if (method == null) {
            return;
        }
        if (allPackageAnnotations.contains(annotation)) {
            return;
        }
        if (Intrinsics.areEqual((Object)qualifiedName, (Object)"com.google.errorprone.annotations.CanIgnoreReturnValue")) {
            return;
        }
        this.checkResult(context2, usage, method, annotation, allMemberAnnotations, allClassAnnotations);
    }

    private final void checkResult(JavaContext context2, UElement element, PsiMethod method, UAnnotation annotation, List<? extends UAnnotation> allMemberAnnotations, List<? extends UAnnotation> allClassAnnotations) {
        if (Companion.isExpressionValueUnused(element)) {
            if (UastLintUtils.Companion.containsAnnotation(allMemberAnnotations, "com.google.errorprone.annotations.CanIgnoreReturnValue") || UastLintUtils.Companion.containsAnnotation(allClassAnnotations, "com.google.errorprone.annotations.CanIgnoreReturnValue")) {
                return;
            }
            if (Intrinsics.areEqual((Object)method.getReturnType(), (Object)PsiType.VOID) || method.isConstructor()) {
                return;
            }
            String methodName = JavaContext.Companion.getMethodName(element);
            String suggested = UastLintUtils.Companion.getAnnotationStringValue(annotation, "suggest");
            Issue issue = CHECK_RESULT;
            if (methodName != null && StringsKt.startsWith$default((String)methodName, (String)"check", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)methodName, (CharSequence)"Permission", (boolean)false, (int)2, null)) {
                issue = CHECK_PERMISSION;
            }
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "The result of `%1$s` is not used";
            Object[] objectArray = new Object[]{methodName};
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
            String message2 = string2;
            if (suggested != null) {
                stringCompanionObject = StringCompanionObject.INSTANCE;
                string = "The result of `%1$s` is not used; did you mean to call `%2$s`?";
                objectArray = new Object[]{methodName, suggested};
                bl = false;
                String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
                message2 = string3;
            } else if (Intrinsics.areEqual((Object)"intersect", (Object)methodName) && context2.getEvaluator().isMemberInClass((PsiMember)method, "android.graphics.Rect")) {
                message2 = message2 + ". If the rectangles do not intersect, no change is made and the original rectangle is not modified. These methods return false to indicate that this has happened.";
            }
            LintFix fix = suggested != null ? this.fix().data(suggested) : null;
            Location location = context2.getLocation(element);
            this.report(context2, issue, element, location, message2, fix);
        }
    }

    static {
        Companion = new Companion(null);
        IMPLEMENTATION = new Implementation(CheckResultDetector.class, Scope.JAVA_FILE_SCOPE);
        CHECK_RESULT = Issue.Companion.create("CheckResult", "Ignoring results", "\n                Some methods have no side effects, and calling them without doing something \\\n                without the result is suspicious.", Category.CORRECTNESS, 6, Severity.WARNING, IMPLEMENTATION);
        Collection collection = null;
        EnumSet enumSet = null;
        Implementation implementation = IMPLEMENTATION;
        boolean bl = false;
        Boolean bl2 = true;
        Severity severity = Severity.WARNING;
        int n = 6;
        String string = null;
        Category category = Category.SECURITY;
        CHECK_PERMISSION = Issue.Companion.create$default(Issue.Companion, "UseCheckPermission", "Using the result of check permission calls", "\n                You normally want to use the result of checking a permission; these methods \\\n                return whether the permission is held; they do not throw an error if the \\\n                permission is not granted. Code which does not do anything with the return \\\n                value probably meant to be calling the enforce methods instead, e.g. rather \\\n                than `Context#checkCallingPermission` it should call \\\n                `Context#enforceCallingPermission`.", implementation, string, category, n, severity, bl, bl2, enumSet, collection, 3344, null);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/android/tools/lint/checks/CheckResultDetector$Companion;", "", "()V", "CHECK_PERMISSION", "Lcom/android/tools/lint/detector/api/Issue;", "CHECK_RESULT", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "isExpressionValueUnused", "", "element", "Lorg/jetbrains/uast/UElement;", "android.sdktools.lint-checks"})
    public static final class Companion {
        public final boolean isExpressionValueUnused(@NotNull UElement element) {
            UExpression uExpression = (UExpression)UastUtils.getParentOfType((UElement)element, UExpression.class, (boolean)false);
            if (uExpression == null) {
                return true;
            }
            UExpression prev = uExpression;
            UElement uElement = prev.getUastParent();
            if (uElement == null) {
                return true;
            }
            UElement curr = uElement;
            while (curr instanceof UQualifiedReferenceExpression && ((UQualifiedReferenceExpression)curr).getSelector() == prev) {
                prev = (UExpression)curr;
                if (curr.getUastParent() != null) continue;
                return true;
            }
            if (curr instanceof UBlockExpression) {
                if (curr.getUastParent() instanceof ULambdaExpression && Lint.isKotlin(curr.getSourcePsi())) {
                    return false;
                }
                UElement block = curr;
                UExpression expression = prev;
                int index = ((UBlockExpression)block).getExpressions().indexOf(expression);
                if (index == -1) {
                    return true;
                }
                if (index < ((UBlockExpression)block).getExpressions().size() - 1) {
                    return true;
                }
                if (Lint.isJava(curr.getSourcePsi())) {
                    return true;
                }
                UElement uElement2 = curr.getUastParent();
                if (uElement2 == null) {
                    return true;
                }
                UElement parent = uElement2;
                if (parent instanceof UMethod || parent instanceof UClassInitializer) {
                    return true;
                }
                return this.isExpressionValueUnused(parent);
            }
            return curr instanceof UMethod && ((UMethod)curr).isConstructor();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

