/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uast;

import com.intellij.lang.Language;
import com.intellij.lang.MetaLanguage;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UastLanguagePlugin;

public final class UastMetaLanguage
extends MetaLanguage {
    private final Set<Language> myLanguages;

    private UastMetaLanguage() {
        super("UAST");
        Collection<UastLanguagePlugin> languagePlugins = UastLanguagePlugin.Companion.getInstances();
        this.myLanguages = new HashSet<Language>(languagePlugins.size());
        this.initLanguages(languagePlugins);
        UastLanguagePlugin.Companion.getExtensionPointName().addChangeListener(() -> {
            this.myLanguages.clear();
            this.initLanguages(UastLanguagePlugin.Companion.getInstances());
        }, null);
    }

    private void initLanguages(Collection<UastLanguagePlugin> languagePlugins) {
        for (UastLanguagePlugin plugin : languagePlugins) {
            this.myLanguages.add(plugin.getLanguage());
        }
    }

    public boolean matchesLanguage(@NotNull Language language2) {
        return this.myLanguages.contains(language2);
    }

    @NotNull
    public Collection<Language> getMatchingLanguages() {
        return Collections.unmodifiableSet(this.myLanguages);
    }
}

