/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.searches;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedMembersSearch;
import com.intellij.psi.search.searches.AnnotatedPackagesSearch;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.MergeQuery;
import com.intellij.util.Query;
import org.jetbrains.annotations.NotNull;

public final class AnnotationTargetsSearch {
    public static AnnotationTargetsSearch INSTANCE = new AnnotationTargetsSearch();

    private AnnotationTargetsSearch() {
    }

    public static Query<PsiModifierListOwner> search(@NotNull PsiClass annotationClass, @NotNull SearchScope scope) {
        Query<PsiMember> members = AnnotatedMembersSearch.search(annotationClass, scope);
        Query<PsiPackage> packages = AnnotatedPackagesSearch.search(annotationClass, scope);
        return new MergeQuery(members, packages);
    }

    public static Query<PsiModifierListOwner> search(@NotNull PsiClass annotationClass) {
        return AnnotationTargetsSearch.search(annotationClass, (SearchScope)GlobalSearchScope.allScope((Project)PsiUtilCore.getProjectInReadAction((PsiElement)annotationClass)));
    }

    public static class Parameters {
        private final PsiClass myAnnotationClass;
        private final SearchScope myScope;

        public Parameters(PsiClass annotationClass, SearchScope scope) {
            this.myAnnotationClass = annotationClass;
            this.myScope = scope;
        }

        public PsiClass getAnnotationClass() {
            return this.myAnnotationClass;
        }

        public SearchScope getScope() {
            return this.myScope;
        }
    }
}

