/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.indexing.IdFilter;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiShortNamesCache {
    public static final ExtensionPointName<PsiShortNamesCache> EP_NAME = ExtensionPointName.create((String)"com.intellij.java.shortNamesCache");

    public static PsiShortNamesCache getInstance(Project project) {
        return (PsiShortNamesCache)ServiceManager.getService((Project)project, PsiShortNamesCache.class);
    }

    public PsiFile @NotNull [] getFilesByName(@NotNull String name) {
        return PsiFile.EMPTY_ARRAY;
    }

    public String @NotNull [] getAllFileNames() {
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    public abstract PsiClass @NotNull [] getClassesByName(@NotNull @NonNls String var1, @NotNull GlobalSearchScope var2);

    public abstract String @NotNull [] getAllClassNames();

    public boolean processAllClassNames(@NotNull Processor<? super String> processor) {
        return ContainerUtil.process((Object[])this.getAllClassNames(), processor);
    }

    public boolean processAllClassNames(@NotNull Processor<? super String> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter2) {
        return ContainerUtil.process((Object[])this.getAllClassNames(), processor);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.2")
    public void getAllClassNames(@NotNull HashSet<? super String> dest) {
        this.processAllClassNames((Processor<? super String>)new CommonProcessors.CollectProcessor(dest));
    }

    public abstract PsiMethod @NotNull [] getMethodsByName(@NonNls @NotNull String var1, @NotNull GlobalSearchScope var2);

    public abstract PsiMethod @NotNull [] getMethodsByNameIfNotMoreThan(@NonNls @NotNull String var1, @NotNull GlobalSearchScope var2, int var3);

    public abstract PsiField @NotNull [] getFieldsByNameIfNotMoreThan(@NonNls @NotNull String var1, @NotNull GlobalSearchScope var2, int var3);

    public abstract boolean processMethodsWithName(@NonNls @NotNull String var1, @NotNull GlobalSearchScope var2, @NotNull Processor<? super PsiMethod> var3);

    public boolean processMethodsWithName(@NonNls @NotNull String name, @NotNull Processor<? super PsiMethod> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter2) {
        return this.processMethodsWithName(name, scope, processor);
    }

    public boolean processAllMethodNames(@NotNull Processor<? super String> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter2) {
        return ContainerUtil.process((Object[])this.getAllMethodNames(), processor);
    }

    public boolean processAllFieldNames(@NotNull Processor<? super String> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter2) {
        return ContainerUtil.process((Object[])this.getAllFieldNames(), processor);
    }

    public abstract String @NotNull [] getAllMethodNames();

    public abstract PsiField @NotNull [] getFieldsByName(@NotNull @NonNls String var1, @NotNull GlobalSearchScope var2);

    public abstract String @NotNull [] getAllFieldNames();

    public boolean processFieldsWithName(@NotNull String name, @NotNull Processor<? super PsiField> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter2) {
        return ContainerUtil.process((Object[])this.getFieldsByName(name, scope), processor);
    }

    public boolean processClassesWithName(@NotNull String name, @NotNull Processor<? super PsiClass> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter2) {
        return ContainerUtil.process((Object[])this.getClassesByName(name, scope), processor);
    }
}

