/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.augment;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentFactoryMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiAugmentProvider {
    private static final Logger LOG = Logger.getInstance(PsiAugmentProvider.class);
    public static final ExtensionPointName<PsiAugmentProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.lang.psiAugmentProvider");
    private final Key<CachedValue<Map<Class, List>>> myCacheKey = Key.create((String)this.getClass().getName());

    @NotNull
    protected <Psi extends PsiElement> List<Psi> getAugments(@NotNull PsiElement element, @NotNull Class<Psi> type, @Nullable String nameHint) {
        if (nameHint == null) {
            return this.getAugments(element, type);
        }
        Map cache = (Map)CachedValuesManager.getCachedValue((PsiElement)element, this.myCacheKey, () -> {
            ConcurrentMap map = ConcurrentFactoryMap.createMap(c -> this.getAugments(element, (Class)c));
            return CachedValueProvider.Result.create((Object)map, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
        return (List)cache.get(type);
    }

    @Deprecated
    @NotNull
    protected <Psi extends PsiElement> List<Psi> getAugments(@NotNull PsiElement element, @NotNull Class<Psi> type) {
        return Collections.emptyList();
    }

    @Nullable
    protected PsiType inferType(@NotNull PsiTypeElement typeElement) {
        return null;
    }

    protected boolean canInferType(@NotNull PsiTypeElement typeElement) {
        return this.inferType(typeElement) != null;
    }

    @NotNull
    protected Set<String> transformModifiers(@NotNull PsiModifierList modifierList, @NotNull Set<String> modifiers) {
        return modifiers;
    }

    @Deprecated
    @NotNull
    public static <Psi extends PsiElement> List<Psi> collectAugments(@NotNull PsiElement element, @NotNull Class<? extends Psi> type) {
        return PsiAugmentProvider.collectAugments(element, type, null);
    }

    @NotNull
    public static <Psi extends PsiElement> List<Psi> collectAugments(@NotNull PsiElement element, @NotNull Class<? extends Psi> type, @Nullable String nameHint) {
        SmartList result = new SmartList();
        PsiAugmentProvider.forEach(element.getProject(), (Processor<? super PsiAugmentProvider>)((Processor)arg_0 -> PsiAugmentProvider.lambda$collectAugments$2(element, type, nameHint, (List)result, arg_0)));
        return result;
    }

    @Nullable
    public static PsiType getInferredType(@NotNull PsiTypeElement typeElement) {
        Ref result = Ref.create();
        PsiAugmentProvider.forEach(typeElement.getProject(), (Processor<? super PsiAugmentProvider>)((Processor)provider -> {
            PsiType type = provider.inferType(typeElement);
            if (type != null) {
                try {
                    PsiUtil.ensureValidType(type);
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw PluginException.createByClass((Throwable)e, provider.getClass());
                }
                result.set((Object)type);
                return false;
            }
            return true;
        }));
        return (PsiType)result.get();
    }

    public static boolean isInferredType(@NotNull PsiTypeElement typeElement) {
        AtomicBoolean result = new AtomicBoolean();
        PsiAugmentProvider.forEach(typeElement.getProject(), (Processor<? super PsiAugmentProvider>)((Processor)provider -> {
            boolean canInfer = provider.canInferType(typeElement);
            if (canInfer) {
                result.set(true);
            }
            return !canInfer;
        }));
        return result.get();
    }

    @NotNull
    public static Set<String> transformModifierProperties(@NotNull PsiModifierList modifierList, @NotNull Project project, @NotNull Set<String> modifiers) {
        Ref result = Ref.create(modifiers);
        PsiAugmentProvider.forEach(project, (Processor<? super PsiAugmentProvider>)((Processor)provider -> {
            result.set(provider.transformModifiers(modifierList, Collections.unmodifiableSet((Set)result.get())));
            return true;
        }));
        return (Set)result.get();
    }

    private static void forEach(Project project, Processor<? super PsiAugmentProvider> processor) {
        boolean dumb = DumbService.isDumb((Project)project);
        for (PsiAugmentProvider provider : EP_NAME.getExtensionList()) {
            if (dumb && !DumbService.isDumbAware((Object)provider)) continue;
            try {
                boolean goOn = processor.process((Object)provider);
                if (goOn) continue;
                break;
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                Logger.getInstance(PsiAugmentProvider.class).error("provider: " + provider, (Throwable)e);
            }
        }
    }

    private static /* synthetic */ boolean lambda$collectAugments$2(PsiElement element, Class type, String nameHint, List result, PsiAugmentProvider provider) {
        List augments = provider.getAugments(element, type, nameHint);
        for (PsiElement augment : augments) {
            if (nameHint != null && augment instanceof PsiNamedElement && !nameHint.equals(((PsiNamedElement)augment).getName())) continue;
            try {
                PsiUtilCore.ensureValid((PsiElement)augment);
                result.add(augment);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                LOG.error((Throwable)PluginException.createByClass((Throwable)e, provider.getClass()));
            }
        }
        return true;
    }
}

