/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLambdaExpressionType;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceType;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWildcardType;
import org.jetbrains.annotations.NotNull;

public class PsiTypeVisitor<A> {
    public A visitType(@NotNull PsiType type) {
        return null;
    }

    public A visitPrimitiveType(@NotNull PsiPrimitiveType primitiveType) {
        return this.visitType(primitiveType);
    }

    public A visitArrayType(@NotNull PsiArrayType arrayType) {
        return this.visitType(arrayType);
    }

    public A visitClassType(@NotNull PsiClassType classType) {
        return this.visitType(classType);
    }

    public A visitCapturedWildcardType(@NotNull PsiCapturedWildcardType capturedWildcardType) {
        return this.visitWildcardType(capturedWildcardType.getWildcard());
    }

    public A visitWildcardType(@NotNull PsiWildcardType wildcardType) {
        return this.visitType(wildcardType);
    }

    public A visitEllipsisType(@NotNull PsiEllipsisType ellipsisType) {
        return this.visitArrayType(ellipsisType);
    }

    public A visitDisjunctionType(@NotNull PsiDisjunctionType disjunctionType) {
        return this.visitType(disjunctionType);
    }

    public A visitIntersectionType(@NotNull PsiIntersectionType intersectionType) {
        PsiType type = intersectionType.getConjuncts()[0];
        return type.accept(this);
    }

    public A visitDiamondType(@NotNull PsiDiamondType diamondType) {
        return this.visitType(diamondType);
    }

    public A visitLambdaExpressionType(@NotNull PsiLambdaExpressionType lambdaExpressionType) {
        PsiLambdaExpression lambdaExpression = lambdaExpressionType.getExpression();
        PsiType interfaceType = lambdaExpression.getFunctionalInterfaceType();
        if (interfaceType != null && LambdaUtil.isFunctionalType(interfaceType)) {
            return interfaceType.accept(this);
        }
        return this.visitType(lambdaExpressionType);
    }

    public A visitMethodReferenceType(@NotNull PsiMethodReferenceType methodReferenceType) {
        PsiMethodReferenceExpression expression = methodReferenceType.getExpression();
        PsiType interfaceType = expression.getFunctionalInterfaceType();
        if (interfaceType != null && LambdaUtil.isFunctionalType(interfaceType)) {
            return interfaceType.accept(this);
        }
        return this.visitType(methodReferenceType);
    }
}

