/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PsiClassNamePatternCondition;
import com.intellij.patterns.PsiMemberPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PsiClassPattern
extends PsiMemberPattern<PsiClass, PsiClassPattern> {
    protected PsiClassPattern() {
        super(PsiClass.class);
    }

    public PsiClassPattern inheritorOf(final boolean strict, final PsiClassPattern pattern) {
        return (PsiClassPattern)this.with((PatternCondition)new PatternCondition<PsiClass>("inheritorOf"){

            public boolean accepts(@NotNull PsiClass psiClass, ProcessingContext context) {
                return PsiClassPattern.isInheritor(psiClass, (ElementPattern)pattern, context, !strict);
            }
        });
    }

    private static boolean isInheritor(PsiClass psiClass, ElementPattern pattern, ProcessingContext matchingContext, boolean checkThisClass) {
        if (psiClass == null) {
            return false;
        }
        if (checkThisClass && pattern.accepts((Object)psiClass, matchingContext)) {
            return true;
        }
        if (PsiClassPattern.isInheritor(psiClass.getSuperClass(), pattern, matchingContext, true)) {
            return true;
        }
        for (PsiClass aClass : psiClass.getInterfaces()) {
            if (!PsiClassPattern.isInheritor(aClass, pattern, matchingContext, true)) continue;
            return true;
        }
        return false;
    }

    public PsiClassPattern inheritorOf(final boolean strict, final String className) {
        return (PsiClassPattern)this.with((PatternCondition)new PatternCondition<PsiClass>("inheritorOf"){

            public boolean accepts(@NotNull PsiClass psiClass, ProcessingContext context) {
                return InheritanceUtil.isInheritor(psiClass, strict, className);
            }
        });
    }

    public PsiClassPattern isInterface() {
        return (PsiClassPattern)this.with((PatternCondition)new PatternCondition<PsiClass>("isInterface"){

            public boolean accepts(@NotNull PsiClass psiClass, ProcessingContext context) {
                return psiClass.isInterface();
            }
        });
    }

    public PsiClassPattern isAnnotationType() {
        return (PsiClassPattern)this.with((PatternCondition)new PatternCondition<PsiClass>("isAnnotationType"){

            public boolean accepts(@NotNull PsiClass psiClass, ProcessingContext context) {
                return psiClass.isAnnotationType();
            }
        });
    }

    public PsiClassPattern withMethod(final boolean checkDeep, final ElementPattern<? extends PsiMethod> memberPattern) {
        return (PsiClassPattern)this.with((PatternCondition)new PatternCondition<PsiClass>("withMethod"){

            public boolean accepts(@NotNull PsiClass psiClass, ProcessingContext context) {
                for (PsiMethod method : checkDeep ? psiClass.getAllMethods() : psiClass.getMethods()) {
                    if (!memberPattern.accepts((Object)method, context)) continue;
                    return true;
                }
                return false;
            }
        });
    }

    public PsiClassPattern withField(final boolean checkDeep, final ElementPattern<? extends PsiField> memberPattern) {
        return (PsiClassPattern)this.with((PatternCondition)new PatternCondition<PsiClass>("withField"){

            public boolean accepts(@NotNull PsiClass psiClass, ProcessingContext context) {
                for (PsiField field : checkDeep ? psiClass.getAllFields() : psiClass.getFields()) {
                    if (!memberPattern.accepts((Object)field, context)) continue;
                    return true;
                }
                return false;
            }
        });
    }

    public PsiClassPattern nonAnnotationType() {
        return (PsiClassPattern)this.with((PatternCondition)new PatternCondition<PsiClass>("nonAnnotationType"){

            public boolean accepts(@NotNull PsiClass psiClass, ProcessingContext context) {
                return !psiClass.isAnnotationType();
            }
        });
    }

    public PsiClassPattern withQualifiedName(@NonNls @NotNull String qname) {
        return (PsiClassPattern)this.with(new PsiClassNamePatternCondition((ElementPattern<String>)StandardPatterns.string().equalTo((Object)qname)));
    }

    public PsiClassPattern withQualifiedName(@NonNls @NotNull ElementPattern<String> qname) {
        return (PsiClassPattern)this.with(new PsiClassNamePatternCondition(qname));
    }
}

