/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.jvm.util;

import com.intellij.lang.jvm.JvmClass;
import com.intellij.lang.jvm.util.JvmUtil;
import com.intellij.openapi.progress.ProgressManager;
import gnu.trove.THashSet;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public class JvmHierarchyUtil {
    private JvmHierarchyUtil() {
    }

    public static boolean testSupers(@NotNull JvmClass start, boolean skipStart, @NotNull Predicate<? super JvmClass> predicate) {
        Boolean result = JvmHierarchyUtil.traverseSupers(start, skipStart, it -> predicate.test((JvmClass)it) ? Boolean.TRUE : null);
        return result != null && result != false;
    }

    public static <R> R traverseSupers(@NotNull JvmClass start, @NotNull Function<? super JvmClass, R> f) {
        return JvmHierarchyUtil.traverseSupers(start, false, f);
    }

    public static <R> R traverseSupers(@NotNull JvmClass start, boolean skipStart, @NotNull Function<? super JvmClass, R> f) {
        ArrayDeque<JvmClass> queue = new ArrayDeque<JvmClass>();
        if (skipStart) {
            JvmHierarchyUtil.queueSupers(queue, start);
        } else {
            queue.offer(start);
        }
        THashSet visited = new THashSet();
        while (!queue.isEmpty()) {
            ProgressManager.checkCanceled();
            JvmClass current = (JvmClass)queue.remove();
            if (!visited.add(current)) continue;
            R result = f.apply(current);
            if (result != null) {
                return result;
            }
            JvmHierarchyUtil.queueSupers(queue, current);
        }
        return null;
    }

    private static void queueSupers(@NotNull Queue<? super JvmClass> queue, @NotNull JvmClass current) {
        JvmClass superClass = JvmUtil.resolveClass(current.getSuperClassType());
        if (superClass != null) {
            queue.offer(superClass);
        }
        for (JvmClass anInterface : JvmUtil.resolveClasses(current.getInterfaceTypes())) {
            queue.offer(anInterface);
        }
    }
}

