/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.jvm.util;

import com.intellij.lang.jvm.JvmClass;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JvmClassUtil {
    private JvmClassUtil() {
    }

    @Nullable
    public static String getJvmClassName(@NotNull JvmClass aClass) {
        String qualifiedName;
        SmartList parts = new SmartList();
        JvmClass current = aClass;
        while (true) {
            JvmClass containingClass;
            if ((containingClass = current.getContainingClass()) == null) {
                qualifiedName = current.getQualifiedName();
                if (qualifiedName == null) {
                    return null;
                }
                break;
            }
            String name = current.getName();
            if (name == null) {
                return null;
            }
            parts.add(name);
            current = containingClass;
        }
        parts.add(qualifiedName);
        return StringUtil.join((Collection)ContainerUtil.reverse((List)parts), (String)"$");
    }

    @Contract(pure=true)
    @NotNull
    public static Comparator<JvmClass> createScopeComparator(@NotNull GlobalSearchScope scope) {
        return (c1, c2) -> {
            VirtualFile file1 = PsiUtilCore.getVirtualFile((PsiElement)c1.getSourceElement());
            VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)c2.getSourceElement());
            if (file1 == null) {
                return file2 == null ? 0 : -1;
            }
            if (file2 == null) {
                return 1;
            }
            return scope.compare(file2, file1);
        };
    }
}

