/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.filters.ExceptionInfo;
import com.intellij.execution.filters.ExceptionInfoCache;
import com.intellij.execution.filters.ExceptionLineRefiner;
import com.intellij.execution.filters.ExceptionWorker;
import com.intellij.execution.filters.Filter;
import com.intellij.openapi.project.DumbAware;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ExceptionFilter
implements Filter,
DumbAware {
    final ExceptionInfoCache myCache;
    private ExceptionLineRefiner myNextLineRefiner;

    public ExceptionFilter(@NotNull GlobalSearchScope scope) {
        this.myCache = new ExceptionInfoCache(scope);
    }

    public Filter.Result applyFilter(@NotNull String line, int textEndOffset) {
        List<Filter.ResultItem> exceptionResults;
        ExceptionWorker worker = new ExceptionWorker(this.myCache);
        Filter.Result result = worker.execute(line, textEndOffset, this.myNextLineRefiner);
        if (result == null) {
            ExceptionInfo exceptionInfo;
            if (this.myNextLineRefiner != null) {
                this.myNextLineRefiner = this.myNextLineRefiner.consumeNextLine(line);
                if (this.myNextLineRefiner != null) {
                    return null;
                }
            }
            this.myNextLineRefiner = (exceptionInfo = ExceptionInfo.parseMessage(line, textEndOffset)) == null ? null : exceptionInfo.getPositionRefiner();
            return null;
        }
        ExceptionInfo prevLineException = this.myNextLineRefiner == null ? null : this.myNextLineRefiner.getExceptionInfo();
        this.myNextLineRefiner = worker.getLocationRefiner();
        if (prevLineException != null && !(exceptionResults = this.getExceptionClassNameItems(prevLineException)).isEmpty()) {
            exceptionResults.add((Filter.ResultItem)result);
            return new Filter.Result(exceptionResults);
        }
        return result;
    }

    @NotNull
    List<Filter.ResultItem> getExceptionClassNameItems(ExceptionInfo prevLineException) {
        return Collections.emptyList();
    }
}

