/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.JavaCommandLine;
import com.intellij.execution.configurations.JavaCommandLineStateUtil;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.target.TargetEnvironmentAwareRunProfileState;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.execution.target.local.LocalTargetEnvironmentFactory;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.registry.Registry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaCommandLineState
extends CommandLineState
implements JavaCommandLine,
TargetEnvironmentAwareRunProfileState {
    private static final Logger LOG = Logger.getInstance(JavaCommandLineState.class);
    private JavaParameters myParams;
    private TargetedCommandLineBuilder myCommandLine;

    protected JavaCommandLineState(@NotNull ExecutionEnvironment environment) {
        super(environment);
    }

    @Override
    public JavaParameters getJavaParameters() throws ExecutionException {
        if (this.myParams == null) {
            this.myParams = (JavaParameters)((Object)ReadAction.compute(this::createJavaParameters));
        }
        return this.myParams;
    }

    public void clear() {
        this.myParams = null;
    }

    @NotNull
    protected OSProcessHandler startProcess() throws ExecutionException {
        return JavaCommandLineStateUtil.startProcess(this.createCommandLine(), this.ansiColoringEnabled());
    }

    protected boolean ansiColoringEnabled() {
        return true;
    }

    protected abstract JavaParameters createJavaParameters() throws ExecutionException;

    public synchronized void prepareTargetEnvironmentRequest(@NotNull TargetEnvironmentRequest request, @Nullable TargetEnvironmentConfiguration configuration, @NotNull ProgressIndicator progressIndicator) throws ExecutionException {
        progressIndicator.setText(ExecutionBundle.message((String)"progress.text.prepare.target.requirements", (Object[])new Object[0]));
        this.myCommandLine = this.createTargetedCommandLine(request, configuration);
    }

    @NotNull
    protected synchronized TargetedCommandLineBuilder getTargetedCommandLine() {
        if (this.myCommandLine != null) {
            return this.myCommandLine;
        }
        if (Experiments.getInstance().isFeatureEnabled("run.targets") && !(this.getEnvironment().getTargetEnvironmentFactory() instanceof LocalTargetEnvironmentFactory)) {
            LOG.error("Command line hasn't been built yet. Probably you need to run environment#getPreparedTargetEnvironment first, or it return the environment from the previous run session");
        }
        try {
            this.getEnvironment().prepareTargetEnvironment((RunProfileState)this, (ProgressIndicator)new EmptyProgressIndicator());
            return this.myCommandLine;
        }
        catch (ExecutionException e) {
            LOG.error((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @NotNull
    protected TargetedCommandLineBuilder createTargetedCommandLine(@NotNull TargetEnvironmentRequest request, @Nullable TargetEnvironmentConfiguration configuration) throws ExecutionException {
        JavaParameters javaParameters = this.getJavaParameters();
        if (!javaParameters.isDynamicClasspath()) {
            javaParameters.setUseDynamicClasspath(this.getEnvironment().getProject());
        }
        return javaParameters.toCommandLine(request, configuration);
    }

    protected GeneralCommandLine createCommandLine() throws ExecutionException {
        LocalTargetEnvironmentFactory factory = new LocalTargetEnvironmentFactory();
        boolean redirectErrorStream = Registry.is((String)"run.processes.with.redirectedErrorStream", (boolean)false);
        TargetEnvironmentRequest request = factory.createRequest();
        TargetedCommandLineBuilder targetedCommandLineBuilder = this.createTargetedCommandLine(request, factory.getTargetConfiguration());
        return factory.prepareRemoteEnvironment(request, (ProgressIndicator)new EmptyProgressIndicator()).createGeneralCommandLine(targetedCommandLineBuilder.build()).withRedirectErrorStream(redirectErrorStream);
    }

    public boolean shouldAddJavaProgramRunnerActions() {
        return true;
    }
}

