/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler;

import com.intellij.compiler.ModuleSourceSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.RootModelProvider;
import com.intellij.openapi.roots.ui.configuration.DefaultModulesProvider;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.util.Couple;
import com.intellij.util.Chunk;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphAlgorithms;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.graph.InboundSemiGraph;
import com.intellij.util.modules.CircularModuleDependenciesDetector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public final class ModuleCompilerUtil {
    private static final Logger LOG = Logger.getInstance(ModuleCompilerUtil.class);

    private ModuleCompilerUtil() {
    }

    public static Module @NotNull [] getDependencies(Module module) {
        return ModuleRootManager.getInstance((Module)module).getDependencies();
    }

    @NotNull
    private static Graph<Module> createModuleGraph(final Module @NotNull [] modules) {
        return GraphGenerator.generate((InboundSemiGraph)CachingSemiGraph.cache((InboundSemiGraph)new InboundSemiGraph<Module>(){

            @NotNull
            public Collection<Module> getNodes() {
                return Arrays.asList(modules);
            }

            @NotNull
            public Iterator<Module> getIn(Module module) {
                return Arrays.asList(ModuleCompilerUtil.getDependencies(module)).iterator();
            }
        }));
    }

    @NotNull
    public static List<Chunk<Module>> getSortedModuleChunks(@NotNull Project project, @NotNull List<? extends Module> modules) {
        Module[] allModules = ModuleManager.getInstance((Project)project).getModules();
        List<Chunk<Module>> chunks = ModuleCompilerUtil.getSortedChunks(ModuleCompilerUtil.createModuleGraph(allModules));
        HashSet<? extends Module> modulesSet = new HashSet<Module>(modules);
        chunks.removeIf(chunk -> !ContainerUtil.intersects((Collection)chunk.getNodes(), (Collection)modulesSet));
        return chunks;
    }

    @NotNull
    private static <Node> List<Chunk<Node>> getSortedChunks(@NotNull Graph<Node> graph) {
        Graph<Chunk<Node>> chunkGraph = ModuleCompilerUtil.toChunkGraph(graph);
        ArrayList<Chunk<Node>> chunks = new ArrayList<Chunk<Node>>(chunkGraph.getNodes());
        DFSTBuilder builder = new DFSTBuilder(chunkGraph);
        if (!builder.isAcyclic()) {
            LOG.error("Acyclic graph expected");
            return null;
        }
        chunks.sort(builder.comparator());
        return chunks;
    }

    @NotNull
    public static <Node> Graph<Chunk<Node>> toChunkGraph(@NotNull Graph<Node> graph) {
        return GraphAlgorithms.getInstance().computeSCCGraph(graph);
    }

    public static void sortModules(Project project, List<? extends Module> modules) {
        ApplicationManager.getApplication().runReadAction(() -> {
            Comparator comparator = ModuleManager.getInstance((Project)project).moduleDependencyComparator();
            modules.sort(comparator);
        });
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2018.2")
    public static Couple<Module> addingDependencyFormsCircularity(@NotNull Module currentModule, @NotNull Module toDependOn) {
        return CircularModuleDependenciesDetector.addingDependencyFormsCircularity((Module)currentModule, (Module)toDependOn);
    }

    @NotNull
    public static List<Chunk<ModuleSourceSet>> getCyclicDependencies(@NotNull Project project, @NotNull List<? extends Module> modules) {
        List<Chunk<ModuleSourceSet>> chunks = ModuleCompilerUtil.computeSourceSetCycles((ModulesProvider)new DefaultModulesProvider(project));
        HashSet<? extends Module> modulesSet = new HashSet<Module>(modules);
        return ContainerUtil.filter(chunks, chunk -> {
            for (ModuleSourceSet sourceSet : chunk.getNodes()) {
                if (!modulesSet.contains(sourceSet.getModule())) continue;
                return true;
            }
            return false;
        });
    }

    @NotNull
    private static Graph<ModuleSourceSet> createModuleSourceDependenciesGraph(final @NotNull RootModelProvider provider) {
        return GraphGenerator.generate((InboundSemiGraph)CachingSemiGraph.cache((InboundSemiGraph)new InboundSemiGraph<ModuleSourceSet>(){

            @NotNull
            public Collection<ModuleSourceSet> getNodes() {
                Module[] modules = provider.getModules();
                ArrayList<ModuleSourceSet> result = new ArrayList<ModuleSourceSet>(modules.length * 2);
                for (Module module : modules) {
                    result.add(new ModuleSourceSet(module, ModuleSourceSet.Type.PRODUCTION));
                    result.add(new ModuleSourceSet(module, ModuleSourceSet.Type.TEST));
                }
                return result;
            }

            @NotNull
            public Iterator<ModuleSourceSet> getIn(ModuleSourceSet n) {
                ModuleRootModel model = provider.getRootModel(n.getModule());
                OrderEnumerator enumerator = model.orderEntries().compileOnly();
                if (n.getType() == ModuleSourceSet.Type.PRODUCTION) {
                    enumerator = enumerator.productionOnly();
                }
                ArrayList<ModuleSourceSet> deps = new ArrayList<ModuleSourceSet>();
                enumerator.forEachModule(module -> {
                    deps.add(new ModuleSourceSet((Module)module, n.getType()));
                    return true;
                });
                if (n.getType() == ModuleSourceSet.Type.TEST) {
                    deps.add(new ModuleSourceSet(n.getModule(), ModuleSourceSet.Type.PRODUCTION));
                }
                return deps.iterator();
            }
        }));
    }

    @NotNull
    public static List<Chunk<ModuleSourceSet>> computeSourceSetCycles(@NotNull ModulesProvider provider) {
        Graph<ModuleSourceSet> graph = ModuleCompilerUtil.createModuleSourceDependenciesGraph((RootModelProvider)provider);
        Collection chunks = GraphAlgorithms.getInstance().computeStronglyConnectedComponents(graph);
        return ModuleCompilerUtil.removeSingleElementChunks(ModuleCompilerUtil.removeDummyNodes(ModuleCompilerUtil.filterDuplicates(ModuleCompilerUtil.removeSingleElementChunks(chunks)), provider));
    }

    private static List<Chunk<ModuleSourceSet>> removeDummyNodes(List<? extends Chunk<ModuleSourceSet>> chunks, ModulesProvider modulesProvider) {
        ArrayList<Chunk<ModuleSourceSet>> result = new ArrayList<Chunk<ModuleSourceSet>>(chunks.size());
        for (Chunk<ModuleSourceSet> chunk : chunks) {
            LinkedHashSet<ModuleSourceSet> nodes = new LinkedHashSet<ModuleSourceSet>();
            for (ModuleSourceSet sourceSet : chunk.getNodes()) {
                if (ModuleCompilerUtil.isDummy(sourceSet, modulesProvider)) continue;
                nodes.add(sourceSet);
            }
            result.add((Chunk<ModuleSourceSet>)new Chunk(nodes));
        }
        return result;
    }

    private static boolean isDummy(ModuleSourceSet set, ModulesProvider modulesProvider) {
        JavaSourceRootType type = set.getType() == ModuleSourceSet.Type.PRODUCTION ? JavaSourceRootType.SOURCE : JavaSourceRootType.TEST_SOURCE;
        ModuleRootModel rootModel = modulesProvider.getRootModel(set.getModule());
        for (ContentEntry entry : rootModel.getContentEntries()) {
            if (entry.getSourceFolders((JpsModuleSourceRootType)type).isEmpty()) continue;
            return false;
        }
        return true;
    }

    private static List<Chunk<ModuleSourceSet>> removeSingleElementChunks(Collection<? extends Chunk<ModuleSourceSet>> chunks) {
        return ContainerUtil.filter(chunks, chunk -> chunk.getNodes().size() > 1);
    }

    @NotNull
    private static List<Chunk<ModuleSourceSet>> filterDuplicates(@NotNull Collection<? extends Chunk<ModuleSourceSet>> sourceSetCycles) {
        ArrayList<Set<Module>> productionCycles = new ArrayList<Set<Module>>();
        for (Chunk<ModuleSourceSet> chunk2 : sourceSetCycles) {
            ModuleSourceSet.Type type = ModuleCompilerUtil.getCommonType(chunk2);
            if (type != ModuleSourceSet.Type.PRODUCTION) continue;
            productionCycles.add(ModuleSourceSet.getModules(chunk2.getNodes()));
        }
        return ContainerUtil.filter(sourceSetCycles, chunk -> {
            if (ModuleCompilerUtil.getCommonType((Chunk<? extends ModuleSourceSet>)chunk) != ModuleSourceSet.Type.TEST) {
                return true;
            }
            for (Set productionCycle : productionCycles) {
                if (!productionCycle.containsAll(ModuleSourceSet.getModules(chunk.getNodes()))) continue;
                return false;
            }
            return true;
        });
    }

    @Nullable
    private static ModuleSourceSet.Type getCommonType(@NotNull Chunk<? extends ModuleSourceSet> cycle) {
        ModuleSourceSet.Type type = null;
        for (ModuleSourceSet set : cycle.getNodes()) {
            if (type == null) {
                type = set.getType();
                continue;
            }
            if (type == set.getType()) continue;
            return null;
        }
        return type;
    }
}

