/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.structure;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.util.Function;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementNavigationProvider;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.ElementPresentation;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomStructureTreeElement
implements StructureViewTreeElement,
ItemPresentation {
    private final DomElement myElement;
    private final Function<DomElement, DomService.StructureViewMode> myDescriptor;
    private final DomElementNavigationProvider myNavigationProvider;

    public DomStructureTreeElement(@NotNull DomElement element, @NotNull Function<DomElement, DomService.StructureViewMode> descriptor, @Nullable DomElementNavigationProvider navigationProvider) {
        this.myElement = element;
        this.myDescriptor = descriptor;
        this.myNavigationProvider = navigationProvider;
    }

    public DomElement getElement() {
        return this.myElement;
    }

    @Nullable
    public Object getValue() {
        return this.myElement.isValid() ? this.myElement.getXmlElement() : null;
    }

    @NotNull
    public ItemPresentation getPresentation() {
        return this;
    }

    public TreeElement @NotNull [] getChildren() {
        if (!this.myElement.isValid()) {
            return EMPTY_ARRAY;
        }
        final ArrayList result = new ArrayList();
        DomElementVisitor elementVisitor = new DomElementVisitor(){

            public void visitDomElement(DomElement element) {
                if (element instanceof GenericDomValue) {
                    return;
                }
                DomService.StructureViewMode viewMode = (DomService.StructureViewMode)DomStructureTreeElement.this.myDescriptor.fun((Object)element);
                switch (viewMode) {
                    case SHOW: {
                        result.add(DomStructureTreeElement.this.createChildElement(element));
                        break;
                    }
                    case SHOW_CHILDREN: {
                        DomUtil.acceptAvailableChildren((DomElement)element, (DomElementVisitor)this);
                        break;
                    }
                }
            }
        };
        DomUtil.acceptAvailableChildren((DomElement)this.myElement, (DomElementVisitor)elementVisitor);
        return result.toArray(TreeElement.EMPTY_ARRAY);
    }

    protected StructureViewTreeElement createChildElement(DomElement element) {
        return new DomStructureTreeElement(element, this.myDescriptor, this.myNavigationProvider);
    }

    public void navigate(boolean requestFocus) {
        if (this.myNavigationProvider != null) {
            this.myNavigationProvider.navigate(this.myElement, requestFocus);
        }
    }

    public boolean canNavigate() {
        return this.myNavigationProvider != null && this.myNavigationProvider.canNavigate(this.myElement);
    }

    public boolean canNavigateToSource() {
        return this.myNavigationProvider != null && this.myNavigationProvider.canNavigate(this.myElement);
    }

    public String getPresentableText() {
        if (!this.myElement.isValid()) {
            return "<unknown>";
        }
        try {
            ElementPresentation presentation = this.myElement.getPresentation();
            String name = presentation.getElementName();
            return name != null ? name : presentation.getTypeName();
        }
        catch (IndexNotReadyException e) {
            return "Name not available during indexing";
        }
    }

    @Nullable
    public String getLocationString() {
        return null;
    }

    @Nullable
    public Icon getIcon(boolean open) {
        if (!this.myElement.isValid()) {
            return null;
        }
        return this.myElement.getPresentation().getIcon();
    }
}

