/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ChooseComponentsToExportDialog;
import com.intellij.configurationStore.ChooseComponentsToExportDialogKt;
import com.intellij.configurationStore.ConfigurationStoreBundle;
import com.intellij.configurationStore.ExportSettingsActionKt;
import com.intellij.configurationStore.ExportableItem;
import com.intellij.configurationStore.ImportSettingsActionKt;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.ImportSettingsFilenameFilter;
import com.intellij.ide.startup.StartupActionScriptManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ConfigImportHelper;
import com.intellij.openapi.application.CustomConfigMigrationOption;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.MessageUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.PathKt;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.awt.Component;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.zip.ZipException;
import javax.swing.Icon;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\n\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0015J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000fH\u0014J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000fH\u0002J(\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0016H\u0014J\u001c\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00140\u00162\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00140\u0016H\u0014J\u001c\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00162\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00140\u0016H\u0002J\b\u0010\u001b\u001a\u00020\u000bH\u0002J\u0010\u0010\u001c\u001a\n \u001d*\u0004\u0018\u00010\u000b0\u000bH\u0002J\b\u0010\u001e\u001a\u00020\u0005H\u0002J\u0010\u0010\u001f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006 "}, d2={"Lcom/intellij/configurationStore/ImportSettingsAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "confirmRestart", "", "message", "", "doImport", "saveFile", "Ljava/io/File;", "Ljava/nio/file/Path;", "doImportFromDirectory", "getExportableComponents", "", "", "Lcom/intellij/configurationStore/ExportableItem;", "relativePaths", "", "getMarkedComponents", "components", "getRelativeNamesToExtract", "chosenComponents", "getRestartActionName", "promptLocationMessage", "kotlin.jvm.PlatformType", "restart", "update", "intellij.platform.configurationStore.impl"})
public class ImportSettingsAction
extends AnAction
implements DumbAware {
    public void update(@NotNull AnActionEvent e) {
        e.getPresentation().setEnabled(ExportSettingsActionKt.isImportExportActionApplicable());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Component component = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(dataContext);
        ChooseComponentsToExportDialogKt.chooseSettingsFile(PathManager.getConfigPath(), component, ConfigurationStoreBundle.message("title.import.file.location", new Object[0]), ConfigurationStoreBundle.message("prompt.choose.import.file.path", new Object[0])).onSuccess((Consumer)new Consumer<VirtualFile>(this){
            final /* synthetic */ ImportSettingsAction this$0;

            public final void accept(VirtualFile it) {
                Path saveFile = Paths.get(it.getPath(), new String[0]);
                try {
                    this.this$0.doImport(saveFile);
                }
                catch (ZipException e1) {
                    Messages.showErrorDialog((String)ConfigurationStoreBundle.message("error.reading.settings.file", saveFile, e1.getMessage(), ImportSettingsAction.access$promptLocationMessage(this.this$0)), (String)ConfigurationStoreBundle.message("title.invalid.file", new Object[0]));
                }
                catch (IOException e1) {
                    Messages.showErrorDialog((String)ConfigurationStoreBundle.message("error.reading.settings.file.2", saveFile, e1.getMessage()), (String)IdeBundle.message((String)"title.error.reading.file", (Object[])new Object[0]));
                }
            }
            {
                this.this$0 = importSettingsAction;
            }
        });
    }

    @NotNull
    protected Map<Path, List<ExportableItem>> getExportableComponents(@NotNull Set<String> relativePaths) {
        return ExportSettingsActionKt.getExportableComponentsMap$default(false, true, null, relativePaths, 4, null);
    }

    @NotNull
    protected Set<ExportableItem> getMarkedComponents(@NotNull Set<ExportableItem> components) {
        return components;
    }

    @Deprecated(message="", replaceWith=@ReplaceWith(imports={}, expression="doImport(saveFile.toPath())"))
    protected void doImport(@NotNull File saveFile) {
        this.doImport(saveFile.toPath());
    }

    protected void doImport(@NotNull Path saveFile) {
        if (!PathKt.exists((Path)saveFile)) {
            Messages.showErrorDialog((String)ConfigurationStoreBundle.message("error.cannot.find.file", saveFile), (String)ConfigurationStoreBundle.message("title.file.not.found", new Object[0]));
            return;
        }
        if (PathKt.isDirectory((Path)saveFile)) {
            this.doImportFromDirectory(saveFile);
            return;
        }
        Set<String> relativePaths = ImportSettingsActionKt.getPaths(PathKt.inputStream((Path)saveFile));
        if (!relativePaths.contains("IntelliJ IDEA Global Settings")) {
            Messages.showErrorDialog((String)IdeBundle.message((String)"error.file.contains.no.settings.to.import", (Object[])new Object[]{saveFile, this.promptLocationMessage()}), (String)ConfigurationStoreBundle.message("title.invalid.file", new Object[0]));
            return;
        }
        String configPath = FileUtil.toSystemIndependentName((String)PathManager.getConfigPath());
        ChooseComponentsToExportDialog dialog = new ChooseComponentsToExportDialog(this.getExportableComponents(relativePaths), false, ConfigurationStoreBundle.message("title.select.components.to.import", new Object[0]), ConfigurationStoreBundle.message("prompt.check.components.to.import", new Object[0]));
        if (!dialog.showAndGet()) {
            return;
        }
        Path tempFile = Paths.get(PathManager.getPluginTempPath(), new String[0]).resolve(saveFile.getFileName());
        PathKt.copy((Path)saveFile, (Path)tempFile);
        ImportSettingsFilenameFilter filenameFilter = new ImportSettingsFilenameFilter(this.getRelativeNamesToExtract(this.getMarkedComponents(dialog.getExportableComponents$intellij_platform_configurationStore_impl())));
        StartupActionScriptManager.addActionCommands((List)CollectionsKt.listOf((Object[])new Object[]{new StartupActionScriptManager.UnzipCommand(tempFile.toFile(), new File(configPath), (FilenameFilter)filenameFilter), new StartupActionScriptManager.DeleteCommand(tempFile.toFile())}));
        UpdateSettings.getInstance().forceCheckForUpdateAfterRestart();
        if (this.confirmRestart(ConfigurationStoreBundle.message("message.settings.imported.successfully", this.getRestartActionName(), ApplicationNamesInfo.getInstance().getFullProductName()))) {
            this.restart();
        }
    }

    private final void restart() {
        ModalityState modalityState$iv = null;
        boolean $i$f$invokeLater = false;
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            public final void run() {
                boolean bl = false;
                Application application = ApplicationManager.getApplication();
                if (application == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.application.ex.ApplicationEx");
                }
                ((ApplicationEx)application).restart(true);
            }
        }, ModalityState.defaultModalityState());
    }

    private final boolean confirmRestart(String message) {
        return MessageUtil.showOkCancelDialog$default((String)IdeBundle.message((String)"title.restart.needed", (Object[])new Object[0]), (String)message, (String)this.getRestartActionName(), null, (Icon)Messages.getQuestionIcon(), null, null, (int)104, null) == 0;
    }

    private final String getRestartActionName() {
        return ApplicationManager.getApplication().isRestartCapable() ? IdeBundle.message((String)"ide.restart.action", (Object[])new Object[0]) : IdeBundle.message((String)"ide.shutdown.action", (Object[])new Object[0]);
    }

    private final void doImportFromDirectory(Path saveFile) {
        String confirmationMessage = ConfigurationStoreBundle.message("import.settings.confirmation.message", saveFile) + "\n\n" + ConfigurationStoreBundle.message("restore.default.settings.confirmation.message", ConfigImportHelper.getBackupPath());
        if (this.confirmRestart(confirmationMessage)) {
            new CustomConfigMigrationOption.MigrateFromCustomPlace(saveFile).writeConfigMarkerFile();
            this.restart();
        }
    }

    private final Set<String> getRelativeNamesToExtract(Set<ExportableItem> chosenComponents) {
        ObjectOpenHashSet result = new ObjectOpenHashSet();
        Path root = PathManager.getConfigDir();
        for (ExportableItem item : chosenComponents) {
            result.add((Object)PathKt.getSystemIndependentPath((Path)root.relativize(item.getFile())));
        }
        result.add((Object)"installed.txt");
        return (Set)result;
    }

    private final String promptLocationMessage() {
        return IdeBundle.message((String)"message.please.ensure.correct.settings", (Object[])new Object[0]);
    }

    public static final /* synthetic */ String access$promptLocationMessage(ImportSettingsAction $this) {
        return $this.promptLocationMessage();
    }
}

