/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.Client;
import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClientShellHelper {
    private static final String RUNAS = "run-as";
    private static final String USER_ARG = "--user";
    @NotNull
    private final Client myClient;
    @Nullable
    private final String myPackageNameOverride;

    public ClientShellHelper(@NotNull Client client, @Nullable String packageNameOverride) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        this.myClient = client;
        this.myPackageNameOverride = packageNameOverride;
        if (this.isRestrictedUser()) {
            CollectingOutputReceiver receiver = new CollectingOutputReceiver();
            client.getDevice().executeShellCommand(RUNAS, (IShellOutputReceiver)receiver);
            if (!receiver.getOutput().contains(USER_ARG)) {
                throw new IllegalStateException("Native debugging under restricted user is not supported yet.");
            }
        }
    }

    @NotNull
    public String getRunAsCommand(@NotNull String command) {
        String prefix = String.format("%s %s", RUNAS, this.getPackageName());
        if (this.isRestrictedUser()) {
            prefix = String.format("%s %s %d", prefix, USER_ARG, this.myClient.getClientData().getUserId());
        }
        return prefix + " " + command;
    }

    @NotNull
    public String getDataDir() {
        if (this.myPackageNameOverride == null) {
            return this.myClient.getClientData().getDataDir();
        }
        String clientDataDir = this.myClient.getClientData().getDataDir();
        if (this.myClient.getClientData().getPackageName() == null) {
            return clientDataDir;
        }
        return clientDataDir.replace(this.myClient.getClientData().getPackageName(), this.myPackageNameOverride);
    }

    @Nullable
    public String getPackageName() {
        return this.myPackageNameOverride != null ? this.myPackageNameOverride : this.myClient.getClientData().getPackageName();
    }

    private boolean isRestrictedUser() {
        return this.myClient.getClientData().isValidUserId() && this.myClient.getClientData().getUserId() > 0;
    }
}

