/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni.reference;

import com.android.tools.ndk.jni.model.JvmMethodInfo;
import com.android.tools.ndk.jni.model.MethodInfo;
import com.android.tools.ndk.jni.reference.JniReferencesSearchKt;
import com.android.tools.ndk.jni.utils.JniUtilsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.OCLanguage;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00032\u000e\u0010\b\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/android/tools/ndk/jni/reference/JniMethodReferencesSearch;", "Lcom/intellij/openapi/application/QueryExecutorBase;", "Lcom/intellij/psi/PsiReference;", "Lcom/intellij/psi/search/searches/MethodReferencesSearch$SearchParameters;", "()V", "processQuery", "", "queryParameters", "consumer", "Lcom/intellij/util/Processor;", "android-ndk"})
public final class JniMethodReferencesSearch
extends QueryExecutorBase<PsiReference, MethodReferencesSearch.SearchParameters> {
    public void processQuery(@NotNull MethodReferencesSearch.SearchParameters queryParameters, @NotNull Processor<? super PsiReference> consumer) {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            return;
        }
        if (((Boolean)OCLanguage.LANGUAGE_SUPPORT_DISABLED.get((UserDataHolder)queryParameters.getProject(), (Object)true)).booleanValue()) {
            return;
        }
        SearchScope augmentedScope = JniReferencesSearchKt.access$augmentScopeForSearch(queryParameters.getProject(), queryParameters.getEffectiveSearchScope());
        PsiMethod element = queryParameters.getMethod();
        MethodInfo methodInfo = MethodInfo.Companion.fromPsiElement((PsiElement)element, false);
        if (!(methodInfo instanceof JvmMethodInfo)) {
            methodInfo = null;
        }
        JvmMethodInfo jvmMethodInfo = (JvmMethodInfo)methodInfo;
        if (jvmMethodInfo == null) {
            return;
        }
        JvmMethodInfo methodInfo2 = jvmMethodInfo;
        SearchScope narrowedScope = JniUtilsKt.narrowDown$default(augmentedScope, element.getProject(), null, CollectionsKt.listOf((Object[])new String[]{methodInfo2.getMethodName(), methodInfo2.getMethodType()}), 2, null);
        JniReferencesSearchKt.access$searchReferencesInGetMethodIdCalls(element, consumer, narrowedScope);
        JniReferencesSearchKt.access$searchReferencesInRegisterNativesCalls(element, consumer, narrowedScope);
    }

    public JniMethodReferencesSearch() {
        super(true);
    }
}

