/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni.model;

import com.android.sdklib.SdkVersionInfo;
import com.android.tools.ndk.jni.model.FullyQualifiedClassName;
import com.android.tools.ndk.jni.model.JniNativeMethodId;
import com.android.tools.ndk.jni.model.JvmMethodId;
import com.android.tools.ndk.jni.model.JvmMethodInfo;
import com.android.tools.ndk.jni.model.JvmType;
import com.android.tools.ndk.jni.model.JvmTypeKt;
import com.android.tools.ndk.jni.model.MethodInfo;
import com.android.tools.ndk.jni.model.SimpleParameterDeclaration;
import com.android.tools.ndk.jni.service.JniMethodResolver;
import com.android.tools.ndk.jni.utils.JniUtilsKt;
import com.android.tools.ndk.jni.utils.NameGenerator;
import com.intellij.lang.jvm.JvmMethod;
import com.intellij.lang.jvm.JvmModifiersOwner;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.search.usagesSearch.SearchHelpersKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\t\n\u0002\b\u0011\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u0000 C2\u00020\u00012\u00020\u0002:\u0001CBW\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0018\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\t0\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\u0006\u0010\u000f\u001a\u00020\r\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\t\u0010(\u001a\u00020\u0004H\u00c6\u0003J\t\u0010)\u001a\u00020\u0006H\u00c6\u0003J\u001b\u0010*\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\t0\bH\u00c6\u0003J\t\u0010+\u001a\u00020\nH\u00c6\u0003J\t\u0010,\u001a\u00020\rH\u00c6\u0003J\t\u0010-\u001a\u00020\rH\u00c6\u0003J\t\u0010.\u001a\u00020\rH\u00c6\u0003J\t\u0010/\u001a\u00020\u0011H\u00c6\u0003Jk\u00100\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\u001a\b\u0002\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\t0\b2\b\b\u0002\u0010\u000b\u001a\u00020\n2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\r2\b\b\u0002\u0010\u000f\u001a\u00020\r2\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u00c6\u0001J\u0013\u00101\u001a\u00020\r2\b\u00102\u001a\u0004\u0018\u000103H\u00d6\u0003J\u001a\u00104\u001a\u00020\u00062\u0006\u00105\u001a\u00020\r2\b\b\u0002\u00106\u001a\u00020\rH\u0007J\f\u00107\u001a\b\u0012\u0004\u0012\u0002080\bJ\f\u00109\u001a\b\u0012\u0004\u0012\u00020\u00060\bJ\b\u0010:\u001a\u0004\u0018\u00010\u0006J\b\u0010;\u001a\u00020!H\u0016J\t\u0010<\u001a\u00020=H\u00d6\u0001J\u0012\u0010>\u001a\u00020?2\b\b\u0002\u00106\u001a\u00020\rH\u0007J\u0006\u0010@\u001a\u00020AJ\t\u0010B\u001a\u00020\u0006H\u00d6\u0001R#\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u000f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001aR\u0011\u0010\u000e\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u001aR\u0011\u0010\u001c\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001aR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u001aR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0019R\u0011\u0010\u001e\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0019R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010$R\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'\u00a8\u0006D"}, d2={"Lcom/android/tools/ndk/jni/model/JvmMethodInfo;", "Lcom/android/tools/ndk/jni/model/MethodInfo;", "Lcom/intellij/openapi/util/ModificationTracker;", "className", "Lcom/android/tools/ndk/jni/model/FullyQualifiedClassName;", "methodName", "", "args", "", "Lkotlin/Pair;", "Lcom/android/tools/ndk/jni/model/JvmType;", "returnType", "isStatic", "", "isNative", "isConstructor", "psiElement", "Lcom/intellij/psi/PsiElement;", "(Lcom/android/tools/ndk/jni/model/FullyQualifiedClassName;Ljava/lang/String;Ljava/util/List;Lcom/android/tools/ndk/jni/model/JvmType;ZZZLcom/intellij/psi/PsiElement;)V", "getArgs", "()Ljava/util/List;", "getClassName", "()Lcom/android/tools/ndk/jni/model/FullyQualifiedClassName;", "description", "getDescription", "()Ljava/lang/String;", "()Z", "isKotlin", "isOverloadedNativeMethod", "getMethodName", "methodType", "getMethodType", "modificationStamp", "", "nameIdentifier", "getNameIdentifier", "()Lcom/intellij/psi/PsiElement;", "getPsiElement", "getReturnType", "()Lcom/android/tools/ndk/jni/model/JvmType;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "other", "", "generateNativeMethod", "cpp", "eraseArgs", "generateNativeParameterDeclarations", "Lcom/android/tools/ndk/jni/model/SimpleParameterDeclaration;", "getHumanReadableParameterTypes", "getHumanReadableReturnType", "getModificationCount", "hashCode", "", "toJniNativeMethodId", "Lcom/android/tools/ndk/jni/model/JniNativeMethodId;", "toJvmMethodId", "Lcom/android/tools/ndk/jni/model/JvmMethodId;", "toString", "Companion", "android-ndk"})
public final class JvmMethodInfo
extends MethodInfo
implements ModificationTracker {
    private final long modificationStamp;
    @NotNull
    private final FullyQualifiedClassName className;
    @NotNull
    private final String methodName;
    @NotNull
    private final List<Pair<String, JvmType>> args;
    @NotNull
    private final JvmType returnType;
    private final boolean isStatic;
    private final boolean isNative;
    private final boolean isConstructor;
    @NotNull
    private final PsiElement psiElement;
    public static final Companion Companion = new Companion(null);

    public long getModificationCount() {
        return this.getPsiElement().isValid() ? this.getPsiElement().getContainingFile().getModificationStamp() : this.modificationStamp + 1L;
    }

    public final boolean isOverloadedNativeMethod() {
        if (!this.getPsiElement().isValid()) {
            return false;
        }
        return JniMethodResolver.Companion.getInstance(this.getPsiElement().getProject()).isOverloaded(this.className, this.methodName);
    }

    @Override
    @NotNull
    public PsiElement getNameIdentifier() {
        PsiElement psiElement;
        PsiElement psiElement2 = this.getPsiElement();
        if (psiElement2 instanceof PsiMethod) {
            PsiIdentifier psiIdentifier = ((PsiMethod)this.getPsiElement()).getNameIdentifier();
            if (psiIdentifier == null) {
                Intrinsics.throwNpe();
            }
            psiElement = (PsiElement)psiIdentifier;
        } else if (psiElement2 instanceof KtFunction) {
            PsiElement psiElement3 = this.getPsiElement();
            if (psiElement3 instanceof KtNamedFunction) {
                psiElement = ((KtNamedFunction)this.getPsiElement()).getNameIdentifier();
                if (psiElement == null) {
                    Intrinsics.throwNpe();
                }
            } else {
                psiElement = this.getPsiElement();
            }
        } else if (psiElement2 instanceof PsiClass) {
            PsiIdentifier psiIdentifier = ((PsiClass)this.getPsiElement()).getNameIdentifier();
            if (psiIdentifier == null) {
                Intrinsics.throwNpe();
            }
            psiElement = (PsiElement)psiIdentifier;
        } else {
            throw (Throwable)((Object)new AssertionError((Object)"impossible by constructor check"));
        }
        return psiElement;
    }

    @NotNull
    public final JvmMethodId toJvmMethodId() {
        return new JvmMethodId(this.className, this.methodName, this.getMethodType());
    }

    @NotNull
    public final List<String> getHumanReadableParameterTypes() {
        List result;
        block6: {
            PsiElement psiElement;
            block5: {
                if (!this.getPsiElement().isValid()) {
                    return kotlin.collections.CollectionsKt.emptyList();
                }
                boolean bl = false;
                result = new ArrayList();
                psiElement = this.getPsiElement();
                if (!(psiElement instanceof KtFunction)) break block5;
                DeclarationDescriptor declarationDescriptor = PsiModificationUtilsKt.toDescriptor((KtDeclaration)((KtDeclaration)this.getPsiElement()));
                if (!(declarationDescriptor instanceof FunctionDescriptor)) {
                    declarationDescriptor = null;
                }
                FunctionDescriptor functionDescriptor = (FunctionDescriptor)declarationDescriptor;
                if (functionDescriptor == null) {
                    return result;
                }
                FunctionDescriptor descriptor = functionDescriptor;
                ReceiverParameterDescriptor receiverParameterDescriptor = descriptor.getExtensionReceiverParameter();
                CollectionsKt.addIfNotNull((Collection)result, receiverParameterDescriptor != null && (receiverParameterDescriptor = receiverParameterDescriptor.getType()) != null ? receiverParameterDescriptor.toString() : null);
                Iterable $this$forEach$iv = descriptor.getValueParameters();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
                    boolean bl2 = false;
                    result.add(it.getType().toString());
                }
                break block6;
            }
            if (!(psiElement instanceof PsiMethod)) break block6;
            PsiParameter[] $this$forEach$iv = ((PsiMethod)this.getPsiElement()).getParameterList().getParameters();
            boolean $i$f$forEach = false;
            PsiParameter[] psiParameterArray = $this$forEach$iv;
            int n = psiParameterArray.length;
            for (int i = 0; i < n; ++i) {
                PsiParameter element$iv;
                PsiParameter it = element$iv = psiParameterArray[i];
                boolean bl = false;
                result.add(it.getType().getPresentableText());
            }
        }
        return result;
    }

    @Nullable
    public final String getHumanReadableReturnType() {
        String string;
        PsiElement psiElement = this.getPsiElement();
        if (psiElement instanceof KtFunction) {
            FunctionDescriptor functionDescriptor;
            DeclarationDescriptor declarationDescriptor = PsiModificationUtilsKt.toDescriptor((KtDeclaration)((KtDeclaration)this.getPsiElement()));
            if (!(declarationDescriptor instanceof FunctionDescriptor)) {
                declarationDescriptor = null;
            }
            string = (functionDescriptor = (FunctionDescriptor)declarationDescriptor) != null && (functionDescriptor = functionDescriptor.getReturnType()) != null ? functionDescriptor.toString() : null;
        } else if (psiElement instanceof PsiMethod) {
            PsiType psiType = ((PsiMethod)this.getPsiElement()).getReturnType();
            string = psiType != null ? psiType.getPresentableText() : null;
        } else {
            string = psiElement instanceof PsiClass ? "void" : null;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public final JniNativeMethodId toJniNativeMethodId(boolean eraseArgs) {
        JniNativeMethodId jniNativeMethodId;
        if (eraseArgs) {
            jniNativeMethodId = new JniNativeMethodId(this.className, this.methodName, null);
        } else {
            Collection<JvmType> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = this.args;
            String string = this.methodName;
            FullyQualifiedClassName fullyQualifiedClassName = this.className;
            boolean $i$f$map = false;
            void var4_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Pair pair = (Pair)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                JvmType jvmType = (JvmType)it.getSecond();
                collection.add(jvmType);
            }
            collection = (List)destination$iv$iv;
            List list = collection;
            String string2 = string;
            FullyQualifiedClassName fullyQualifiedClassName2 = fullyQualifiedClassName;
            jniNativeMethodId = new JniNativeMethodId(fullyQualifiedClassName2, string2, list);
        }
        return jniNativeMethodId;
    }

    public static /* synthetic */ JniNativeMethodId toJniNativeMethodId$default(JvmMethodInfo jvmMethodInfo, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = !jvmMethodInfo.isOverloadedNativeMethod();
        }
        return jvmMethodInfo.toJniNativeMethodId(bl);
    }

    @JvmOverloads
    @NotNull
    public final JniNativeMethodId toJniNativeMethodId() {
        return JvmMethodInfo.toJniNativeMethodId$default(this, false, 1, null);
    }

    @NotNull
    public final String getMethodType() {
        return '(' + kotlin.collections.CollectionsKt.joinToString$default((Iterable)this.args, (CharSequence)"", null, null, (int)0, null, (Function1)methodType.1.INSTANCE, (int)30, null) + ')' + this.returnType.toJvmType();
    }

    public final boolean isKotlin() {
        return this.getPsiElement() instanceof KtElement;
    }

    @NotNull
    public final String getDescription() {
        return this.methodName + '(' + kotlin.collections.CollectionsKt.joinToString$default((Iterable)this.args, null, null, null, (int)0, null, (Function1)description.1.INSTANCE, (int)31, null) + ')';
    }

    @JvmOverloads
    @NotNull
    public final String generateNativeMethod(boolean cpp, boolean eraseArgs) {
        String externDeclaration = cpp ? "extern \"C\"\n" : "";
        List<SimpleParameterDeclaration> otherArgs = this.generateNativeParameterDeclarations();
        return externDeclaration + StringsKt.trimIndent((String)("\n        JNIEXPORT " + this.returnType.toJniType() + " JNICALL\n        " + this.toJniNativeMethodId(eraseArgs).getFunctionName() + '(' + kotlin.collections.CollectionsKt.joinToString$default((Iterable)otherArgs, null, null, null, (int)0, null, null, (int)63, null) + ") {\n            // TODO: implement " + this.methodName + "()\n        }\n      "));
    }

    public static /* synthetic */ String generateNativeMethod$default(JvmMethodInfo jvmMethodInfo, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl2 = !jvmMethodInfo.isOverloadedNativeMethod();
        }
        return jvmMethodInfo.generateNativeMethod(bl, bl2);
    }

    @JvmOverloads
    @NotNull
    public final String generateNativeMethod(boolean cpp) {
        return JvmMethodInfo.generateNativeMethod$default(this, cpp, false, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<SimpleParameterDeclaration> generateNativeParameterDeclarations() {
        Pair $dstr$name$type;
        Object object;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        NameGenerator nameGenerator = new NameGenerator("env", this.isStatic ? "clazz" : "thiz");
        Iterable iterable = this.args;
        Collection collection = kotlin.collections.CollectionsKt.listOf((Object[])new Pair[]{TuplesKt.to((Object)"JNIEnv *", (Object)"env"), this.isStatic ? TuplesKt.to((Object)"jclass", (Object)"clazz") : TuplesKt.to((Object)"jobject", (Object)"thiz")});
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void name;
            Pair pair = (Pair)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            String string = (String)$dstr$name$type.component1();
            JvmType type = (JvmType)$dstr$name$type.component2();
            Pair pair2 = TuplesKt.to((Object)type.toJniType(), (Object)nameGenerator.generateUniqueName(SdkVersionInfo.camelCaseToUnderlines((String)name)));
            object.add(pair2);
        }
        object = (List)destination$iv$iv;
        $this$map$iv = kotlin.collections.CollectionsKt.plus((Collection)collection, (Iterable)((Iterable)object));
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            $dstr$name$type = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            object = new SimpleParameterDeclaration((Pair<String, String>)it);
            collection.add(object);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final FullyQualifiedClassName getClassName() {
        return this.className;
    }

    @NotNull
    public final String getMethodName() {
        return this.methodName;
    }

    @NotNull
    public final List<Pair<String, JvmType>> getArgs() {
        return this.args;
    }

    @NotNull
    public final JvmType getReturnType() {
        return this.returnType;
    }

    public final boolean isStatic() {
        return this.isStatic;
    }

    public final boolean isNative() {
        return this.isNative;
    }

    public final boolean isConstructor() {
        return this.isConstructor;
    }

    @Override
    @NotNull
    public PsiElement getPsiElement() {
        return this.psiElement;
    }

    public JvmMethodInfo(@NotNull FullyQualifiedClassName className, @NotNull String methodName, @NotNull List<? extends Pair<String, ? extends JvmType>> args, @NotNull JvmType returnType, boolean isStatic, boolean isNative, boolean isConstructor, @NotNull PsiElement psiElement) {
        super(null);
        this.className = className;
        this.methodName = methodName;
        this.args = args;
        this.returnType = returnType;
        this.isStatic = isStatic;
        this.isNative = isNative;
        this.isConstructor = isConstructor;
        this.psiElement = psiElement;
        this.modificationStamp = this.getPsiElement().getContainingFile().getModificationStamp();
        boolean bl = this.getPsiElement() instanceof PsiMethod || this.getPsiElement() instanceof KtFunction || this.getPsiElement() instanceof PsiClass;
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "JvmMethodInfo must be created from a valid PsiMethod, PsiClass, or KtFunction";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
    }

    @NotNull
    public final FullyQualifiedClassName component1() {
        return this.className;
    }

    @NotNull
    public final String component2() {
        return this.methodName;
    }

    @NotNull
    public final List<Pair<String, JvmType>> component3() {
        return this.args;
    }

    @NotNull
    public final JvmType component4() {
        return this.returnType;
    }

    public final boolean component5() {
        return this.isStatic;
    }

    public final boolean component6() {
        return this.isNative;
    }

    public final boolean component7() {
        return this.isConstructor;
    }

    @NotNull
    public final PsiElement component8() {
        return this.getPsiElement();
    }

    @NotNull
    public final JvmMethodInfo copy(@NotNull FullyQualifiedClassName className, @NotNull String methodName, @NotNull List<? extends Pair<String, ? extends JvmType>> args, @NotNull JvmType returnType, boolean isStatic, boolean isNative, boolean isConstructor, @NotNull PsiElement psiElement) {
        return new JvmMethodInfo(className, methodName, args, returnType, isStatic, isNative, isConstructor, psiElement);
    }

    public static /* synthetic */ JvmMethodInfo copy$default(JvmMethodInfo jvmMethodInfo, FullyQualifiedClassName fullyQualifiedClassName, String string, List list, JvmType jvmType, boolean bl, boolean bl2, boolean bl3, PsiElement psiElement, int n, Object object) {
        if ((n & 1) != 0) {
            fullyQualifiedClassName = jvmMethodInfo.className;
        }
        if ((n & 2) != 0) {
            string = jvmMethodInfo.methodName;
        }
        if ((n & 4) != 0) {
            list = jvmMethodInfo.args;
        }
        if ((n & 8) != 0) {
            jvmType = jvmMethodInfo.returnType;
        }
        if ((n & 0x10) != 0) {
            bl = jvmMethodInfo.isStatic;
        }
        if ((n & 0x20) != 0) {
            bl2 = jvmMethodInfo.isNative;
        }
        if ((n & 0x40) != 0) {
            bl3 = jvmMethodInfo.isConstructor;
        }
        if ((n & 0x80) != 0) {
            psiElement = jvmMethodInfo.getPsiElement();
        }
        return jvmMethodInfo.copy(fullyQualifiedClassName, string, list, jvmType, bl, bl2, bl3, psiElement);
    }

    @NotNull
    public String toString() {
        return "JvmMethodInfo(className=" + this.className + ", methodName=" + this.methodName + ", args=" + this.args + ", returnType=" + this.returnType + ", isStatic=" + this.isStatic + ", isNative=" + this.isNative + ", isConstructor=" + this.isConstructor + ", psiElement=" + this.getPsiElement() + ")";
    }

    public int hashCode() {
        FullyQualifiedClassName fullyQualifiedClassName = this.className;
        String string = this.methodName;
        List<Pair<String, JvmType>> list = this.args;
        JvmType jvmType = this.returnType;
        int n = ((((fullyQualifiedClassName != null ? ((Object)fullyQualifiedClassName).hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (list != null ? ((Object)list).hashCode() : 0)) * 31 + (jvmType != null ? jvmType.hashCode() : 0)) * 31;
        int n2 = this.isStatic ? 1 : 0;
        if (n2 != 0) {
            n2 = 1;
        }
        int n3 = (n + n2) * 31;
        int n4 = this.isNative ? 1 : 0;
        if (n4 != 0) {
            n4 = 1;
        }
        int n5 = (n3 + n4) * 31;
        int n6 = this.isConstructor ? 1 : 0;
        if (n6 != 0) {
            n6 = 1;
        }
        PsiElement psiElement = this.getPsiElement();
        return (n5 + n6) * 31 + (psiElement != null ? psiElement.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof JvmMethodInfo)) break block3;
                JvmMethodInfo jvmMethodInfo = (JvmMethodInfo)object;
                if (!Intrinsics.areEqual((Object)this.className, (Object)jvmMethodInfo.className) || !Intrinsics.areEqual((Object)this.methodName, (Object)jvmMethodInfo.methodName) || !Intrinsics.areEqual(this.args, jvmMethodInfo.args) || !Intrinsics.areEqual((Object)this.returnType, (Object)jvmMethodInfo.returnType) || this.isStatic != jvmMethodInfo.isStatic || this.isNative != jvmMethodInfo.isNative || this.isConstructor != jvmMethodInfo.isConstructor || !Intrinsics.areEqual((Object)this.getPsiElement(), (Object)jvmMethodInfo.getPsiElement())) break block3;
            }
            return true;
        }
        return false;
    }

    @JvmStatic
    @Nullable
    public static final JvmMethodInfo fromJavaMethod(@NotNull PsiMethod method) {
        return Companion.fromJavaMethod(method);
    }

    @JvmStatic
    @Nullable
    public static final JvmMethodInfo fromKotlinFunction(@NotNull KtFunction function) {
        return Companion.fromKotlinFunction(function);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\n"}, d2={"Lcom/android/tools/ndk/jni/model/JvmMethodInfo$Companion;", "", "()V", "fromJavaMethod", "Lcom/android/tools/ndk/jni/model/JvmMethodInfo;", "method", "Lcom/intellij/psi/PsiMethod;", "fromKotlinFunction", "function", "Lorg/jetbrains/kotlin/psi/KtFunction;", "android-ndk"})
    public static final class Companion {
        @JvmStatic
        @Nullable
        public final JvmMethodInfo fromJavaMethod(@NotNull PsiMethod method) {
            Application $this$readAction$iv = ApplicationManager.getApplication();
            boolean $i$f$readAction = false;
            return (JvmMethodInfo)ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<JvmMethodInfo>((Object)$this$readAction$iv, method){
                final /* synthetic */ Object $this_readAction;
                final /* synthetic */ PsiMethod $method$inlined;
                {
                    this.$this_readAction = object;
                    this.$method$inlined = psiMethod;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                public final JvmMethodInfo invoke() {
                    JvmMethodInfo jvmMethodInfo;
                    block13: {
                        Application it = (Application)this.$this_readAction;
                        boolean bl = false;
                        PsiClass psiClass = this.$method$inlined.getContainingClass();
                        if (psiClass == null) {
                            JvmMethodInfo jvmMethodInfo2;
                            jvmMethodInfo = jvmMethodInfo2 = null;
                        } else {
                            FullyQualifiedClassName fullyQualifiedClassName = FullyQualifiedClassName.Companion.fromJavaClass(psiClass);
                            if (fullyQualifiedClassName == null) {
                                jvmMethodInfo = null;
                            } else {
                                void $this$mapTo$iv$iv;
                                FullyQualifiedClassName className = fullyQualifiedClassName;
                                PsiParameter[] $this$map$iv = this.$method$inlined.getParameterList().getParameters();
                                boolean $i$f$map = false;
                                PsiParameter[] psiParameterArray = $this$map$iv;
                                Collection destination$iv$iv = new ArrayList<E>($this$map$iv.length);
                                boolean $i$f$mapTo = false;
                                void var10_14 = $this$mapTo$iv$iv;
                                int n = ((void)var10_14).length;
                                for (int i = 0; i < n; ++i) {
                                    JvmType jvmType;
                                    String string;
                                    void it2;
                                    void item$iv$iv;
                                    void var14_18 = item$iv$iv = var10_14[i];
                                    Collection collection = destination$iv$iv;
                                    boolean bl2 = false;
                                    if (it2.getName() == null) {
                                        Object var3_4 = null;
                                        jvmMethodInfo = var3_4;
                                        break block13;
                                    }
                                    if (JvmType.Companion.fromJavaType(it2.getType()) == null) {
                                        Object var3_5 = null;
                                        jvmMethodInfo = var3_5;
                                        break block13;
                                    }
                                    Pair pair = new Pair((Object)string, (Object)jvmType);
                                    collection.add(pair);
                                }
                                List args = (List)destination$iv$iv;
                                if (this.$method$inlined.isConstructor()) {
                                    jvmMethodInfo = new JvmMethodInfo(className, "<init>", args, JvmTypeKt.getVOID_TYPE(), false, false, true, (PsiElement)this.$method$inlined);
                                } else {
                                    PsiType psiType = this.$method$inlined.getReturnType();
                                    if (psiType == null) {
                                        Object var3_6 = null;
                                        jvmMethodInfo = var3_6;
                                    } else {
                                        JvmType jvmType = JvmType.Companion.fromJavaType(psiType);
                                        if (jvmType == null) {
                                            Object var3_7 = null;
                                            jvmMethodInfo = var3_7;
                                        } else {
                                            PsiElement psiElement = (PsiElement)this.$method$inlined;
                                            boolean bl3 = false;
                                            boolean bl4 = JniUtilsKt.isNative((JvmMethod)this.$method$inlined);
                                            boolean bl5 = JniUtilsKt.isStatic((JvmModifiersOwner)this.$method$inlined);
                                            JvmType jvmType2 = jvmType;
                                            List list = args;
                                            String string = this.$method$inlined.getName();
                                            FullyQualifiedClassName fullyQualifiedClassName2 = className;
                                            jvmMethodInfo = new JvmMethodInfo(fullyQualifiedClassName2, string, list, jvmType2, bl5, bl4, bl3, psiElement);
                                        }
                                    }
                                }
                            }
                        }
                    }
                    return jvmMethodInfo;
                }
            }));
        }

        @JvmStatic
        @Nullable
        public final JvmMethodInfo fromKotlinFunction(@NotNull KtFunction function) {
            Application $this$readAction$iv = ApplicationManager.getApplication();
            boolean $i$f$readAction = false;
            return (JvmMethodInfo)ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<JvmMethodInfo>((Object)$this$readAction$iv, function){
                final /* synthetic */ Object $this_readAction;
                final /* synthetic */ KtFunction $function$inlined;
                {
                    this.$this_readAction = object;
                    this.$function$inlined = ktFunction;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                public final JvmMethodInfo invoke() {
                    JvmMethodInfo jvmMethodInfo;
                    block11: {
                        Collection<Pair> collection;
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        Pair pair;
                        Object object;
                        FunctionDescriptor descriptor;
                        block15: {
                            block13: {
                                JvmType jvmType;
                                block14: {
                                    JvmMethodInfo jvmMethodInfo2;
                                    FunctionDescriptor functionDescriptor;
                                    block12: {
                                        Application it = (Application)this.$this_readAction;
                                        boolean bl = false;
                                        DeclarationDescriptor declarationDescriptor = SearchHelpersKt.getDescriptor((KtDeclaration)((KtDeclaration)this.$function$inlined));
                                        if (!(declarationDescriptor instanceof FunctionDescriptor)) {
                                            declarationDescriptor = null;
                                        }
                                        functionDescriptor = (FunctionDescriptor)declarationDescriptor;
                                        if (functionDescriptor != null) break block12;
                                        jvmMethodInfo = null;
                                        break block11;
                                    }
                                    descriptor = functionDescriptor;
                                    ReceiverParameterDescriptor receiverParameterDescriptor = descriptor.getExtensionReceiverParameter();
                                    if (receiverParameterDescriptor == null) break block13;
                                    object = receiverParameterDescriptor;
                                    boolean bl = false;
                                    boolean bl2 = false;
                                    ReceiverParameterDescriptor it = object;
                                    boolean bl3 = false;
                                    jvmType = JvmType.Companion.fromKotlinType$default(JvmType.Companion, it.getType(), false, false, 6, null);
                                    if (jvmType != null) break block14;
                                    jvmMethodInfo = jvmMethodInfo2 = null;
                                    break block11;
                                }
                                pair = TuplesKt.to((Object)"_receiver", (Object)jvmType);
                                break block15;
                            }
                            pair = null;
                        }
                        object = descriptor.getValueParameters();
                        Collection collection2 = kotlin.collections.CollectionsKt.listOfNotNull(pair);
                        boolean $i$f$map = false;
                        void var6_7 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)item$iv$iv;
                            collection = destination$iv$iv;
                            boolean bl = false;
                            JvmType jvmType = JvmType.Companion.fromKotlinType$default(JvmType.Companion, it.getType(), false, false, 6, null);
                            if (jvmType == null) {
                                JvmMethodInfo jvmMethodInfo3;
                                jvmMethodInfo = jvmMethodInfo3 = null;
                                break block11;
                            }
                            Pair pair2 = TuplesKt.to((Object)it.getName().asString(), (Object)jvmType);
                            collection.add(pair2);
                        }
                        collection = (List)destination$iv$iv;
                        List args = kotlin.collections.CollectionsKt.plus((Collection)collection2, (Iterable)collection);
                        FullyQualifiedClassName fullyQualifiedClassName = JniUtilsKt.getContainingJvmClass((KtDeclaration)this.$function$inlined);
                        if (fullyQualifiedClassName == null) {
                            JvmMethodInfo jvmMethodInfo4;
                            jvmMethodInfo = jvmMethodInfo4 = null;
                        } else {
                            String string = JniUtilsKt.getJvmName(this.$function$inlined);
                            if (string == null) {
                                JvmMethodInfo jvmMethodInfo5;
                                jvmMethodInfo = jvmMethodInfo5 = null;
                            } else {
                                KotlinType kotlinType = descriptor.getReturnType();
                                if (kotlinType == null) {
                                    JvmMethodInfo jvmMethodInfo6;
                                    jvmMethodInfo = jvmMethodInfo6 = null;
                                } else {
                                    JvmType jvmType = JvmType.Companion.fromKotlinType$default(JvmType.Companion, kotlinType, true, false, 4, null);
                                    if (jvmType == null) {
                                        JvmMethodInfo jvmMethodInfo7;
                                        jvmMethodInfo = jvmMethodInfo7 = null;
                                    } else {
                                        PsiElement psiElement = (PsiElement)this.$function$inlined;
                                        boolean bl = false;
                                        boolean bl4 = JniUtilsKt.isNative(this.$function$inlined);
                                        boolean bl5 = JniUtilsKt.isStatic((KtDeclaration)this.$function$inlined);
                                        JvmType jvmType2 = jvmType;
                                        List list = args;
                                        String string2 = string;
                                        FullyQualifiedClassName fullyQualifiedClassName2 = fullyQualifiedClassName;
                                        jvmMethodInfo = new JvmMethodInfo(fullyQualifiedClassName2, string2, list, jvmType2, bl5, bl4, bl, psiElement);
                                    }
                                }
                            }
                        }
                    }
                    return jvmMethodInfo;
                }
            }));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

