/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni.inspections;

import com.android.tools.ndk.jni.model.MethodInfo;
import com.android.tools.ndk.jni.model.NativeMethodInfo;
import com.android.tools.ndk.jni.service.JniMethodResolver;
import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.types.OCFunctionType;

public class JniImplicitUsageProvider
implements ImplicitUsageProvider {
    public boolean isImplicitUsage(PsiElement element) {
        if (element instanceof OCDeclarator) {
            MethodInfo methodInfo;
            OCDeclarator declarator = (OCDeclarator)element;
            String name = declarator.getName();
            if (name.equals("JNI_OnLoad") || name.equals("JNI_OnUnload")) {
                return true;
            }
            if (!name.startsWith("Java_")) {
                return false;
            }
            if (declarator.getType() instanceof OCFunctionType && (methodInfo = MethodInfo.fromPsiElement((PsiElement)declarator)) instanceof NativeMethodInfo) {
                NativeMethodInfo nativeMethodInfo = (NativeMethodInfo)methodInfo;
                return !JniMethodResolver.getInstance(element.getProject()).resolveNativeMethod(nativeMethodInfo).isEmpty();
            }
        }
        return false;
    }

    public boolean isImplicitRead(PsiElement element) {
        return false;
    }

    public boolean isImplicitWrite(PsiElement element) {
        return false;
    }
}

