/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.login;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeRequestUrl;
import com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeTokenRequest;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.auth.oauth2.GoogleRefreshTokenRequest;
import com.google.api.client.googleapis.auth.oauth2.GoogleTokenResponse;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson.JacksonFactory;
import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import com.google.gdt.eclipse.login.common.LoggerFacade;
import com.google.gdt.eclipse.login.common.LoginListener;
import com.google.gdt.eclipse.login.common.OAuthData;
import com.google.gdt.eclipse.login.common.OAuthDataStore;
import com.google.gdt.eclipse.login.common.UiFacade;
import com.google.gdt.eclipse.login.common.VerificationCodeHolder;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import org.jetbrains.annotations.Nullable;

public class GoogleLoginState {
    private static final String GET_EMAIL_URL = "https://openidconnect.googleapis.com/v1/userinfo";
    private static final String OAUTH2_NATIVE_CALLBACK_URL = "urn:ietf:wg:oauth:2.0:oob";
    private static final JsonFactory jsonFactory = new JacksonFactory();
    private static final HttpTransport transport = new NetHttpTransport();
    private String clientId;
    private String clientSecret;
    private SortedSet<String> oAuthScopes;
    private OAuthDataStore authDataStore;
    private UiFacade uiFacade;
    private LoggerFacade loggerFacade;
    private Credential oAuth2Credential;
    private String accessToken;
    private long accessTokenExpiryTime;
    private String refreshToken;
    private boolean isLoggedIn;
    private String email;
    private boolean connected;
    private Collection<LoginListener> listeners;

    public GoogleLoginState(String clientId, String clientSecret, SortedSet<String> oAuthScopes, OAuthDataStore authDataStore, UiFacade uiFacade, LoggerFacade loggerFacade) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.oAuthScopes = oAuthScopes;
        this.authDataStore = authDataStore;
        this.uiFacade = uiFacade;
        this.loggerFacade = loggerFacade;
        this.isLoggedIn = false;
        this.email = "";
        this.connected = true;
        this.listeners = Lists.newLinkedList();
        this.retrieveSavedCredentials();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLoginListener(LoginListener listener) {
        Collection<LoginListener> collection = this.listeners;
        synchronized (collection) {
            this.listeners.add(listener);
        }
    }

    public HttpRequestFactory createRequestFactory(@Nullable String message) {
        if (!this.checkLoggedIn(message)) {
            return null;
        }
        return transport.createRequestFactory((HttpRequestInitializer)this.oAuth2Credential);
    }

    public String fetchAccessToken() throws IOException {
        if (!this.checkLoggedIn(null)) {
            return null;
        }
        if (this.accessTokenExpiryTime != 0L) {
            long currentTime = new GregorianCalendar().getTimeInMillis() / 1000L;
            if (currentTime >= this.accessTokenExpiryTime) {
                this.fetchOAuth2Token();
            }
        } else {
            this.fetchOAuth2Token();
        }
        return this.accessToken;
    }

    public String fetchOAuth2ClientId() {
        return this.clientId;
    }

    public String fetchOAuth2ClientSecret() {
        return this.clientSecret;
    }

    public String fetchOAuth2RefreshToken() {
        if (!this.checkLoggedIn(null)) {
            return null;
        }
        return this.refreshToken;
    }

    public String fetchOAuth2Token() throws IOException {
        if (!this.checkLoggedIn(null)) {
            return null;
        }
        try {
            GoogleRefreshTokenRequest request = new GoogleRefreshTokenRequest(transport, jsonFactory, this.refreshToken, this.clientId, this.clientSecret);
            GoogleTokenResponse authResponse = request.execute();
            this.accessToken = authResponse.getAccessToken();
            this.oAuth2Credential.setAccessToken(this.accessToken);
            this.accessTokenExpiryTime = new GregorianCalendar().getTimeInMillis() / 1000L + authResponse.getExpiresInSeconds();
        }
        catch (IOException e) {
            this.loggerFacade.logError("Could not obtain an OAuth2 access token.", (Throwable)e);
            throw e;
        }
        this.saveCredentials();
        return this.accessToken;
    }

    public Credential getCredential() {
        if (this.oAuth2Credential == null) {
            this.oAuth2Credential = this.makeCredential();
        }
        return this.oAuth2Credential;
    }

    public String getEmail() {
        return this.email;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public boolean isLoggedIn() {
        return this.isLoggedIn;
    }

    public boolean logIn(@Nullable String title) {
        GoogleTokenResponse authResponse;
        if (this.isLoggedIn) {
            return true;
        }
        GoogleAuthorizationCodeRequestUrl requestUrl = new GoogleAuthorizationCodeRequestUrl(this.clientId, OAUTH2_NATIVE_CALLBACK_URL, this.oAuthScopes);
        this.connected = true;
        String verificationCode = this.uiFacade.obtainVerificationCodeFromUserInteraction(title, requestUrl);
        if (verificationCode == null) {
            return false;
        }
        GoogleAuthorizationCodeTokenRequest authRequest = new GoogleAuthorizationCodeTokenRequest(transport, jsonFactory, this.clientId, this.clientSecret, verificationCode, OAUTH2_NATIVE_CALLBACK_URL);
        try {
            authResponse = authRequest.execute();
        }
        catch (IOException e) {
            this.uiFacade.showErrorDialog("Error while signing in", "An error occurred while trying to sign in: " + e.getMessage() + ". See the error log for more details.");
            this.loggerFacade.logError("Could not sign in. Make sure that you entered the correct verification code.", (Throwable)e);
            return false;
        }
        this.isLoggedIn = true;
        this.updateUserCredentials(authResponse);
        return true;
    }

    public boolean logInWithLocalServer(@Nullable String title) {
        GoogleTokenResponse authResponse;
        if (this.isLoggedIn) {
            return true;
        }
        this.connected = true;
        VerificationCodeHolder verificationCodeHolder = this.uiFacade.obtainVerificationCodeFromExternalUserInteraction(title);
        if (verificationCodeHolder == null) {
            return false;
        }
        GoogleAuthorizationCodeTokenRequest authRequest = new GoogleAuthorizationCodeTokenRequest(transport, jsonFactory, this.clientId, this.clientSecret, verificationCodeHolder.getVerificationCode(), verificationCodeHolder.getRedirectUrl());
        try {
            authResponse = authRequest.execute();
        }
        catch (IOException e) {
            this.uiFacade.showErrorDialog("Error while signing in", "An error occurred while trying to sign in: " + e.getMessage());
            this.loggerFacade.logError("Could not sign in", (Throwable)e);
            return false;
        }
        this.isLoggedIn = true;
        this.updateUserCredentials(authResponse);
        return true;
    }

    public boolean logOut() {
        return this.logOut(true);
    }

    public boolean logOut(boolean showPrompt) {
        return this.logOut(showPrompt, true);
    }

    public Credential makeCredential() {
        GoogleCredential cred = new GoogleCredential.Builder().setJsonFactory(jsonFactory).setTransport(transport).setClientSecrets(this.clientId, this.clientSecret).build();
        cred.setAccessToken(this.accessToken);
        cred.setRefreshToken(this.refreshToken);
        return cred;
    }

    public void simulateLoginStatusChange(boolean login) {
        if (login) {
            this.retrieveSavedCredentials();
        }
        this.notifyLoginStatusChange(login);
        this.uiFacade.notifyStatusIndicator();
    }

    private void updateUserCredentials(GoogleTokenResponse tokenResponse) {
        this.refreshToken = tokenResponse.getRefreshToken();
        this.accessToken = tokenResponse.getAccessToken();
        this.oAuth2Credential = this.makeCredential();
        this.accessTokenExpiryTime = System.currentTimeMillis() / 1000L + tokenResponse.getExpiresInSeconds();
        this.email = this.queryEmail();
        this.saveCredentials();
        this.uiFacade.notifyStatusIndicator();
        this.notifyLoginStatusChange(true);
    }

    private void retrieveSavedCredentials() {
        OAuthData savedAuthState = this.authDataStore.loadOAuthData();
        if (savedAuthState.getRefreshToken() == null || savedAuthState.getStoredScopes() == null) {
            this.authDataStore.clearStoredOAuthData();
            return;
        }
        this.accessToken = savedAuthState.getAccessToken();
        this.refreshToken = savedAuthState.getRefreshToken();
        this.accessTokenExpiryTime = savedAuthState.getAccessTokenExpiryTime();
        this.email = savedAuthState.getStoredEmail();
        this.isLoggedIn = true;
        if (!this.oAuthScopes.equals(savedAuthState.getStoredScopes())) {
            this.loggerFacade.logWarning("OAuth scope set for stored credentials no longer valid, logging out.");
            this.loggerFacade.logWarning(this.oAuthScopes + " vs. " + savedAuthState.getStoredScopes());
            this.logOut(false);
        }
        this.oAuth2Credential = this.makeCredential();
    }

    private boolean checkLoggedIn(String msg) {
        if (!this.isLoggedIn) {
            boolean rc = this.logIn(msg);
            if (!rc) {
                return false;
            }
            this.uiFacade.notifyStatusIndicator();
        }
        return true;
    }

    private boolean logOut(boolean showPrompt, boolean doRevoke) {
        if (!this.isLoggedIn) {
            return true;
        }
        boolean logOut = true;
        if (showPrompt) {
            logOut = this.uiFacade.askYesOrNo("Sign out?", "Are you sure you want to sign out?");
        }
        if (logOut) {
            this.email = "";
            this.isLoggedIn = false;
            this.authDataStore.clearStoredOAuthData();
            this.notifyLoginStatusChange(false);
            this.uiFacade.notifyStatusIndicator();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyLoginStatusChange(boolean login) {
        Collection<LoginListener> collection = this.listeners;
        synchronized (collection) {
            for (LoginListener listener : this.listeners) {
                try {
                    listener.statusChanged(login);
                }
                catch (Throwable t) {
                    this.loggerFacade.logError("Exception in LoginListener", t);
                }
            }
        }
    }

    private String queryEmail() {
        String url = GET_EMAIL_URL;
        HttpResponse resp = null;
        try {
            HttpRequest get = this.createRequestFactory(null).buildGetRequest(new GenericUrl(url));
            resp = get.execute();
            Type responseData = new TypeToken<LoginResponseHolder>(){}.getType();
            LoginResponseHolder loginResponseHolder = (LoginResponseHolder)new Gson().fromJson((Reader)new InputStreamReader(resp.getContent(), StandardCharsets.UTF_8), responseData);
            String userEmail = loginResponseHolder.getEmail();
            if (userEmail == null) {
                throw new Exception("Response from server is invalid.");
            }
            return userEmail;
        }
        catch (Exception e) {
            this.loggerFacade.logError("Could not parse email after Google service sign-in", (Throwable)e);
            return null;
        }
    }

    private static Map<String, String> parseUrlParameters(String params) throws UnsupportedEncodingException {
        String[] paramArr;
        HashMap<String, String> paramMap = new HashMap<String, String>();
        int qMark = params.indexOf(63);
        if (qMark > -1) {
            params = params.substring(qMark + 1);
        }
        for (String s : paramArr = params.split("&")) {
            String[] keyVal = s.split("=");
            if (keyVal.length != 2) continue;
            paramMap.put(URLDecoder.decode(keyVal[0], "UTF-8"), URLDecoder.decode(keyVal[1], "UTF-8"));
        }
        return paramMap;
    }

    private void saveCredentials() {
        if (!this.isLoggedIn) {
            this.authDataStore.clearStoredOAuthData();
        } else {
            OAuthData creds = new OAuthData(this.accessToken, this.refreshToken, this.email, this.oAuthScopes, this.accessTokenExpiryTime);
            this.authDataStore.saveOAuthData(creds);
        }
    }

    private static class LoginResponseHolder {
        private String sub;
        private String picture;
        private String email;
        private String email_verified;
        private String hd;

        private LoginResponseHolder() {
        }

        private String getSub() {
            return this.sub;
        }

        private String getPicture() {
            return this.picture;
        }

        private String getEmail() {
            return this.email;
        }

        private String getEmail_verified() {
            return this.email_verified;
        }

        private String getHd() {
            return this.hd;
        }
    }
}

