/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.login;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.services.oauth2.model.Userinfoplus;
import com.google.gct.login.GoogleLoginState;
import com.google.gct.login.GoogleLoginUtils;
import com.google.gct.login.IGoogleLoginCompletedCallback;
import java.awt.Image;
import org.jetbrains.annotations.Nullable;

public class CredentialedUser {
    private String name;
    private Image image;
    private final String email;
    private final Credential credential;
    private boolean isActive = false;
    private final GoogleLoginState googleLoginState;

    protected CredentialedUser(String email) {
        this.email = email;
        this.name = "";
        this.credential = null;
        this.image = null;
        this.googleLoginState = null;
    }

    public CredentialedUser(GoogleLoginState state, @Nullable IGoogleLoginCompletedCallback loginCompletedCallback) {
        this.email = state.getEmail();
        this.googleLoginState = state;
        this.credential = this.googleLoginState.makeCredential();
        GoogleLoginUtils.getUserInfo(this.credential, userInfoPlus -> this.initializeUserInfo((Userinfoplus)userInfoPlus, loginCompletedCallback));
    }

    public String getEmail() {
        return this.email;
    }

    public Credential getCredential() {
        return this.credential;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public String getName() {
        return this.name;
    }

    public Image getPicture() {
        return this.image;
    }

    public GoogleLoginState getGoogleLoginState() {
        return this.googleLoginState;
    }

    protected void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    private void initializeUserInfo(Userinfoplus userInfo, @Nullable IGoogleLoginCompletedCallback loginCompletedCallback) {
        if (userInfo == null) {
            this.name = null;
            this.image = null;
        } else {
            this.name = userInfo.getName();
            GoogleLoginUtils.provideUserPicture(userInfo, newImage -> {
                this.image = newImage;
                if (loginCompletedCallback != null) {
                    loginCompletedCallback.onLoginCompleted();
                }
            });
        }
    }
}

