/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.serialization.ClassUtil;
import com.intellij.serialization.MutableAccessor;
import com.intellij.util.xmlb.NestedBinding;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.XmlSerializerImpl;
import org.jdom.Element;
import org.jdom.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class TextBinding
implements NestedBinding {
    private final Class<?> valueClass;
    private final MutableAccessor accessor;

    TextBinding(@NotNull MutableAccessor accessor) {
        this.accessor = accessor;
        this.valueClass = ClassUtil.typeToClass(accessor.getGenericType());
    }

    @Override
    @NotNull
    public MutableAccessor getAccessor() {
        return this.accessor;
    }

    @Override
    @Nullable
    public Object serialize(@NotNull Object o, @Nullable Object context, @Nullable SerializationFilter filter) {
        Object value = this.accessor.read(o);
        return value == null ? null : new Text(XmlSerializerImpl.convertToString(value));
    }

    @Override
    public Object deserializeUnsafe(Object context, @NotNull Element element) {
        return context;
    }

    void set(@NotNull Object context, @NotNull String value) {
        XmlSerializerImpl.doSet(context, value, this.accessor, this.valueClass);
    }
}

