/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.SerializationFilterBase;
import gnu.trove.THashMap;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SkipDefaultValuesSerializationFilters
extends SerializationFilterBase {
    private final Map<Class<?>, Object> myDefaultBeans = new THashMap();

    @Deprecated
    public SkipDefaultValuesSerializationFilters() {
    }

    public SkipDefaultValuesSerializationFilters(Object ... defaultBeans) {
        for (Object defaultBean : defaultBeans) {
            this.myDefaultBeans.put(defaultBean.getClass(), defaultBean);
        }
    }

    @Override
    protected boolean accepts(@NotNull Accessor accessor, @NotNull Object bean, @Nullable Object beanValue) {
        Object defValue = accessor.read(this.getDefaultBean(bean));
        if (defValue instanceof Element && beanValue instanceof Element) {
            return !JDOMUtil.areElementsEqual((Element)beanValue, (Element)defValue);
        }
        return !Comparing.equal(beanValue, defValue);
    }

    @NotNull
    Object getDefaultBean(@NotNull Object bean) {
        Class<?> c = bean.getClass();
        return this.getDefaultValue(c);
    }

    @NotNull
    public Object getDefaultValue(Class<?> c) {
        Object o = this.myDefaultBeans.get(c);
        if (o == null) {
            o = ReflectionUtil.newInstance(c);
            this.configure(o);
            this.myDefaultBeans.put(c, o);
        }
        return o;
    }

    protected void configure(@NotNull Object o) {
    }
}

