/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.serialization.ClassUtil;
import com.intellij.serialization.MutableAccessor;
import com.intellij.util.SmartList;
import com.intellij.util.xmlb.AbstractCollectionBinding;
import java.lang.reflect.ParameterizedType;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CollectionBinding
extends AbstractCollectionBinding {
    CollectionBinding(@NotNull ParameterizedType type, @Nullable MutableAccessor accessor) {
        super(ClassUtil.typeToClass(type.getActualTypeArguments()[0]), accessor);
    }

    @Override
    @NotNull
    protected Object doDeserializeList(@Nullable Object context, @NotNull List<? extends Element> elements) {
        AbstractCollection result;
        boolean isContextMutable;
        boolean bl = isContextMutable = context != null && ClassUtil.isMutableCollection(context);
        if (isContextMutable) {
            result = (AbstractCollection)context;
            result.clear();
        } else {
            result = context instanceof Set ? new HashSet() : new SmartList();
        }
        for (Element element : elements) {
            result.add(this.deserializeItem(element, context));
        }
        return result;
    }

    @Override
    @NotNull
    Collection<?> getIterable(@NotNull Object o) {
        Collection collection = (Collection)o;
        if (collection.size() < 2 || this.isSortOrderedSet() && o instanceof LinkedHashSet || o instanceof SortedSet) {
            return collection;
        }
        if (o instanceof Set) {
            ArrayList result = new ArrayList(collection);
            result.sort(null);
            return result;
        }
        return collection;
    }

    @Override
    @NotNull
    protected String getCollectionTagName(@Nullable Object target) {
        if (target instanceof Set) {
            return "set";
        }
        if (target instanceof List) {
            return "list";
        }
        return "collection";
    }
}

