/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.util.Consumer;
import com.intellij.util.EmptyConsumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CompoundRuntimeException
extends RuntimeException {
    private final List<? extends Throwable> myExceptions;

    public CompoundRuntimeException(@NotNull List<? extends Throwable> throwables) {
        this.myExceptions = throwables;
    }

    @Override
    public synchronized Throwable getCause() {
        return ContainerUtil.getFirstItem(this.myExceptions);
    }

    public List<Throwable> getExceptions() {
        return new ArrayList<Throwable>(this.myExceptions);
    }

    @Override
    public String getMessage() {
        return this.processAll(Throwable::getMessage, EmptyConsumer.getInstance());
    }

    @Override
    public String getLocalizedMessage() {
        return this.processAll(Throwable::getLocalizedMessage, EmptyConsumer.getInstance());
    }

    @Override
    public String toString() {
        return this.processAll(Throwable::toString, EmptyConsumer.getInstance());
    }

    @Override
    public void printStackTrace(PrintStream s) {
        this.processAll(throwable -> {
            throwable.printStackTrace(s);
            return "";
        }, s::print);
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        this.processAll(throwable -> {
            throwable.printStackTrace(s);
            return "";
        }, s::print);
    }

    private String processAll(@NotNull Function<? super Throwable, String> exceptionProcessor, @NotNull Consumer<? super String> stringProcessor) {
        if (this.myExceptions.size() == 1) {
            Throwable throwable = this.myExceptions.get(0);
            String s = exceptionProcessor.fun(throwable);
            stringProcessor.consume(s);
            return s;
        }
        StringBuilder sb = new StringBuilder();
        String line = "CompositeException (" + this.myExceptions.size() + " nested):\n------------------------------\n";
        stringProcessor.consume(line);
        sb.append(line);
        for (int i = 0; i < this.myExceptions.size(); ++i) {
            Throwable exception = this.myExceptions.get(i);
            line = "[" + i + "]: ";
            stringProcessor.consume(line);
            sb.append(line);
            line = exceptionProcessor.fun(exception);
            if (line == null) {
                line = "null\n";
            } else if (!line.endsWith("\n")) {
                line = line + '\n';
            }
            stringProcessor.consume(line);
            sb.append(line);
        }
        line = "------------------------------\n";
        stringProcessor.consume(line);
        sb.append(line);
        return sb.toString();
    }

    public static void throwIfNotEmpty(@Nullable List<? extends Throwable> throwables) {
        if (ContainerUtil.isEmpty(throwables)) {
            return;
        }
        if (throwables.size() != 1) {
            throw new CompoundRuntimeException(throwables);
        }
        ExceptionUtil.rethrow(throwables.get(0));
    }
}

