/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.keyFMap;

import com.intellij.openapi.util.Key;
import com.intellij.util.containers.UnmodifiableHashMap;
import com.intellij.util.keyFMap.DebugFMap;
import com.intellij.util.keyFMap.KeyFMap;
import com.intellij.util.keyFMap.OneElementFMap;
import org.jetbrains.annotations.NotNull;

final class EmptyFMap
implements KeyFMap {
    private static final Key[] EMPTY_KEYS_ARRAY = new Key[0];

    EmptyFMap() {
    }

    @Override
    @NotNull
    public <V> KeyFMap plus(@NotNull Key<V> key, @NotNull V value) {
        return new OneElementFMap<V>(key, value);
    }

    @Override
    @NotNull
    public KeyFMap minus(@NotNull Key<?> key) {
        return this;
    }

    @Override
    public <V> V get(@NotNull Key<V> key) {
        return null;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public Key @NotNull [] getKeys() {
        return EMPTY_KEYS_ARRAY;
    }

    public String toString() {
        return "{}";
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public int getValueIdentityHashCode() {
        return 0;
    }

    @Override
    public boolean equalsByReference(KeyFMap other) {
        return other == this;
    }

    public int hashCode() {
        return 0;
    }

    static KeyFMap create() {
        return DebugFMap.DEBUG_FMAP ? new DebugFMap(UnmodifiableHashMap.empty()) : new EmptyFMap();
    }
}

