/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.ThreadLocalCachedValue;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.CommonProcessors;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.LimitedPool;
import com.intellij.util.containers.SLRUCache;
import com.intellij.util.io.AppendablePersistentMap;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.IOStatistics;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.InlineKeyDescriptor;
import com.intellij.util.io.IntInlineKeyDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentBTreeEnumerator;
import com.intellij.util.io.PersistentEnumeratorBase;
import com.intellij.util.io.PersistentEnumeratorDelegate;
import com.intellij.util.io.PersistentHashMapValueStorage;
import com.intellij.util.io.StorageLockContext;
import com.intellij.util.io.UnsyncByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PersistentHashMap<Key, Value>
implements AppendablePersistentMap<Key, Value> {
    private static final Logger LOG = Logger.getInstance(PersistentHashMap.class);
    private static final boolean myDoTrace = SystemProperties.getBooleanProperty("idea.trace.persistent.map", false);
    private static final int DEAD_KEY_NUMBER_MASK = -1;
    private final Path myStorageFile;
    private final boolean myIsReadOnly;
    private final KeyDescriptor<Key> myKeyDescriptor;
    private PersistentHashMapValueStorage myValueStorage;
    private final SLRUCache<Key, BufferExposingByteArrayOutputStream> myAppendCache;
    private final LowMemoryWatcher myAppendCacheFlusher;
    private final DataExternalizer<Value> myValueExternalizer;
    private static final long NULL_ADDR = 0L;
    private static final int INITIAL_INDEX_SIZE;
    @NonNls
    static final String DATA_FILE_EXTENSION = ".values";
    private long myLiveAndGarbageKeysCounter;
    private int myReadCompactionGarbageSize;
    private static final long LIVE_KEY_MASK = 0x100000000L;
    private static final long USED_LONG_VALUE_MASK = 0x4000000000000000L;
    private static final int POSITIVE_VALUE_SHIFT = 1;
    private final int myParentValueRefOffset;
    private final ThreadLocal<byte @NotNull []> myRecordBuffer;
    private final ThreadLocal<byte @NotNull []> mySmallRecordBuffer;
    private final boolean myIntMapping;
    private final boolean myDirectlyStoreLongFileOffsetMode;
    private final boolean myCanReEnumerate;
    private int myLargeIndexWatermarkId;
    private boolean myIntAddressForNewRecord;
    private static final boolean doHardConsistencyChecks = false;
    private final PersistentEnumeratorBase<Key> myEnumerator;
    private final LimitedPool<BufferExposingByteArrayOutputStream> myStreamPool = new LimitedPool<BufferExposingByteArrayOutputStream>(10, new LimitedPool.ObjectFactory<BufferExposingByteArrayOutputStream>(){

        @Override
        @NotNull
        public BufferExposingByteArrayOutputStream create() {
            return new BufferExposingByteArrayOutputStream();
        }

        @Override
        public void cleanup(@NotNull BufferExposingByteArrayOutputStream appendStream) {
            appendStream.reset();
        }
    });
    private static final int MAX_RECYCLED_BUFFER_SIZE = 4096;
    private static final ThreadLocalCachedValue<AppendStream> ourFlyweightAppenderStream;
    private int smallKeys;
    private int largeKeys;
    private int transformedKeys;
    private int requests;

    public boolean isCorrupted() {
        return this.myEnumerator.isCorrupted();
    }

    private boolean canUseIntAddressForNewRecord(long size) {
        return this.myCanReEnumerate && size + 1L < Integer.MAX_VALUE;
    }

    public PersistentHashMap(@NotNull File file, @NotNull KeyDescriptor<Key> keyDescriptor, @NotNull DataExternalizer<Value> valueExternalizer) throws IOException {
        this(file.toPath(), keyDescriptor, valueExternalizer, INITIAL_INDEX_SIZE);
    }

    public PersistentHashMap(@NotNull Path file, @NotNull KeyDescriptor<Key> keyDescriptor, @NotNull DataExternalizer<Value> valueExternalizer) throws IOException {
        this(file, keyDescriptor, valueExternalizer, INITIAL_INDEX_SIZE);
    }

    public PersistentHashMap(@NotNull Path file, @NotNull KeyDescriptor<Key> keyDescriptor, @NotNull DataExternalizer<Value> valueExternalizer, int initialSize) throws IOException {
        this(file, keyDescriptor, valueExternalizer, initialSize, 0);
    }

    public PersistentHashMap(@NotNull Path file, @NotNull KeyDescriptor<Key> keyDescriptor, @NotNull DataExternalizer<Value> valueExternalizer, int initialSize, int version) throws IOException {
        this(file, keyDescriptor, valueExternalizer, initialSize, version, null);
    }

    public PersistentHashMap(@NotNull Path file, @NotNull KeyDescriptor<Key> keyDescriptor, @NotNull DataExternalizer<Value> valueExternalizer, int initialSize, int version, @Nullable StorageLockContext lockContext) throws IOException {
        this(file, keyDescriptor, valueExternalizer, initialSize, version, lockContext, PersistentHashMapValueStorage.CreationTimeOptions.threadLocalOptions());
    }

    private PersistentHashMap(@NotNull Path file, @NotNull KeyDescriptor<Key> keyDescriptor, @NotNull DataExternalizer<Value> valueExternalizer, int initialSize, int version, @Nullable StorageLockContext lockContext, @NotNull PersistentHashMapValueStorage.CreationTimeOptions options) throws IOException {
        this.myIsReadOnly = this.isReadOnly();
        if (this.myIsReadOnly) {
            options = options.setReadOnly();
        }
        this.myEnumerator = PersistentEnumeratorDelegate.createDefaultEnumerator(PersistentHashMap.checkDataFiles(file), keyDescriptor, initialSize, lockContext, PersistentHashMap.modifyVersionDependingOnOptions(version, options));
        this.myStorageFile = file;
        this.myKeyDescriptor = keyDescriptor;
        final @NotNull PersistentEnumeratorBase.RecordBufferHandler<PersistentEnumeratorBase<?>> recordHandler = this.myEnumerator.getRecordHandler();
        this.myParentValueRefOffset = recordHandler.getRecordBuffer(this.myEnumerator).length;
        this.myIntMapping = valueExternalizer instanceof IntInlineKeyDescriptor && this.wantNonNegativeIntegralValues();
        this.myDirectlyStoreLongFileOffsetMode = keyDescriptor instanceof InlineKeyDescriptor && this.myEnumerator instanceof PersistentBTreeEnumerator;
        this.myRecordBuffer = ThreadLocal.withInitial(() -> this.myDirectlyStoreLongFileOffsetMode ? ArrayUtilRt.EMPTY_BYTE_ARRAY : new byte[this.myParentValueRefOffset + 8]);
        this.mySmallRecordBuffer = ThreadLocal.withInitial(() -> this.myDirectlyStoreLongFileOffsetMode ? ArrayUtilRt.EMPTY_BYTE_ARRAY : new byte[this.myParentValueRefOffset + 4]);
        this.myEnumerator.setRecordHandler(new PersistentEnumeratorBase.RecordBufferHandler<PersistentEnumeratorBase<?>>(){

            @Override
            int recordWriteOffset(PersistentEnumeratorBase<?> enumerator, byte[] buf) {
                return recordHandler.recordWriteOffset(enumerator, buf);
            }

            @Override
            byte @NotNull [] getRecordBuffer(PersistentEnumeratorBase<?> enumerator) {
                return PersistentHashMap.this.myIntAddressForNewRecord ? (byte[])PersistentHashMap.this.mySmallRecordBuffer.get() : (byte[])PersistentHashMap.this.myRecordBuffer.get();
            }

            @Override
            void setupRecord(PersistentEnumeratorBase enumerator, int hashCode, int dataOffset, byte @NotNull [] buf) {
                recordHandler.setupRecord(enumerator, hashCode, dataOffset, buf);
                for (int i = PersistentHashMap.this.myParentValueRefOffset; i < buf.length; ++i) {
                    buf[i] = 0;
                }
            }
        });
        this.myEnumerator.setMarkCleanCallback(new Flushable(){

            @Override
            public void flush() {
                PersistentHashMap.this.myEnumerator.putMetaData(PersistentHashMap.this.myLiveAndGarbageKeysCounter);
                PersistentHashMap.this.myEnumerator.putMetaData2((long)PersistentHashMap.this.myLargeIndexWatermarkId | (long)PersistentHashMap.this.myReadCompactionGarbageSize << 32);
            }
        });
        if (myDoTrace) {
            LOG.info("Opened " + file);
        }
        try {
            this.myValueExternalizer = valueExternalizer;
            this.myValueStorage = this.myIntMapping ? null : new PersistentHashMapValueStorage(PersistentHashMap.getDataFile(file), options);
            this.myAppendCache = this.myIntMapping ? null : this.createAppendCache(keyDescriptor);
            this.myAppendCacheFlusher = this.myIntMapping ? null : LowMemoryWatcher.register(this::dropMemoryCaches);
            this.myLiveAndGarbageKeysCounter = this.myEnumerator.getMetaData();
            long data2 = this.myEnumerator.getMetaData2();
            this.myLargeIndexWatermarkId = (int)(data2 & 0xFFFFFFFFFFFFFFFFL);
            this.myReadCompactionGarbageSize = (int)(data2 >>> 32);
            this.myCanReEnumerate = this.myEnumerator.canReEnumerate();
            if (!options.isReadOnly() && this.makesSenseToCompact()) {
                this.compact();
            }
        }
        catch (IOException e) {
            try {
                this.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw e;
        }
        catch (Throwable t) {
            LOG.error(t);
            try {
                this.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new PersistentEnumeratorBase.CorruptedException(file);
        }
    }

    private static int modifyVersionDependingOnOptions(int version, @NotNull PersistentHashMapValueStorage.CreationTimeOptions options) {
        return version + options.getVersion();
    }

    protected boolean wantNonNegativeIntegralValues() {
        return false;
    }

    protected boolean isReadOnly() {
        return false;
    }

    private SLRUCache<Key, BufferExposingByteArrayOutputStream> createAppendCache(KeyDescriptor<Key> keyDescriptor) {
        return new SLRUCache<Key, BufferExposingByteArrayOutputStream>(16384, 4096, keyDescriptor){

            @Override
            @NotNull
            public BufferExposingByteArrayOutputStream createValue(Key key) {
                return (BufferExposingByteArrayOutputStream)PersistentHashMap.this.myStreamPool.alloc();
            }

            @Override
            protected void onDropFromCache(Key key, @NotNull BufferExposingByteArrayOutputStream bytes) {
                PersistentHashMap.this.myEnumerator.lockStorageWrite();
                try {
                    int id;
                    long previousRecord;
                    if (PersistentHashMap.this.myDirectlyStoreLongFileOffsetMode) {
                        previousRecord = ((PersistentBTreeEnumerator)PersistentHashMap.this.myEnumerator).getNonNegativeValue(key);
                        id = -1;
                    } else {
                        id = PersistentHashMap.this.enumerate(key);
                        previousRecord = PersistentHashMap.this.readValueId(id);
                    }
                    long headerRecord = PersistentHashMap.this.myValueStorage.appendBytes(bytes.toByteArraySequence(), previousRecord);
                    if (PersistentHashMap.this.myDirectlyStoreLongFileOffsetMode) {
                        ((PersistentBTreeEnumerator)PersistentHashMap.this.myEnumerator).putNonNegativeValue(key, headerRecord);
                    } else {
                        PersistentHashMap.this.updateValueId(id, headerRecord, previousRecord, key, 0);
                    }
                    if (previousRecord == 0L) {
                        PersistentHashMap.this.myLiveAndGarbageKeysCounter = PersistentHashMap.this.myLiveAndGarbageKeysCounter + 0x100000000L;
                    }
                    if (bytes.getInternalBuffer().length <= 4096) {
                        PersistentHashMap.this.myStreamPool.recycle(bytes);
                    }
                }
                catch (IOException e) {
                    PersistentHashMap.this.myEnumerator.markCorrupted();
                    throw new RuntimeException(e);
                }
                finally {
                    PersistentHashMap.this.myEnumerator.unlockStorageWrite();
                }
            }
        };
    }

    @NotNull
    public Object getDataAccessLock() {
        return this.myEnumerator.getDataAccessLock();
    }

    private static boolean doNewCompact() {
        return System.getProperty("idea.persistent.hash.map.oldcompact") == null;
    }

    private boolean forceNewCompact() {
        return System.getProperty("idea.persistent.hash.map.newcompact") != null && (int)(this.myLiveAndGarbageKeysCounter & 0xFFFFFFFFFFFFFFFFL) > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dropMemoryCaches() {
        if (myDoTrace) {
            LOG.info("Drop memory caches " + this.myStorageFile);
        }
        Object object = this.getDataAccessLock();
        synchronized (object) {
            this.doDropMemoryCaches();
        }
    }

    protected void doDropMemoryCaches() {
        this.myEnumerator.lockStorageWrite();
        try {
            this.clearAppenderCaches();
        }
        finally {
            this.myEnumerator.unlockStorageWrite();
        }
    }

    public int getSize() {
        return (int)(this.myLiveAndGarbageKeysCounter / 0x100000000L);
    }

    int getGarbageSize() {
        return (int)this.myLiveAndGarbageKeysCounter;
    }

    public Path getBaseFile() {
        return this.myEnumerator.myFile;
    }

    public boolean makesSenseToCompact() {
        if (!this.isCompactionSupported()) {
            return false;
        }
        long fileSize = this.myValueStorage.getSize();
        int megabyte = 0x100000;
        if (fileSize > 0x500000L) {
            int liveKeys = (int)(this.myLiveAndGarbageKeysCounter / 0x100000000L);
            int deadKeys = (int)(this.myLiveAndGarbageKeysCounter & 0xFFFFFFFFFFFFFFFFL);
            if (fileSize > 0x3200000L && this.forceNewCompact()) {
                return true;
            }
            if (deadKeys < 50) {
                return false;
            }
            long benefitSize = Math.max(0x6400000L, fileSize / 4L);
            long avgValueSize = fileSize / (long)(liveKeys + deadKeys);
            return deadKeys > liveKeys || avgValueSize * (long)deadKeys > benefitSize || (long)this.myReadCompactionGarbageSize > fileSize / 2L;
        }
        return false;
    }

    @NotNull
    private static Path checkDataFiles(@NotNull Path file) {
        if (!Files.exists(file, new LinkOption[0])) {
            PersistentHashMap.deleteFilesStartingWith(PersistentHashMap.getDataFile(file).toFile());
        }
        return file;
    }

    public static void deleteFilesStartingWith(@NotNull File prefixFile) {
        IOUtil.deleteAllFilesStartingWith(prefixFile);
    }

    public static void deleteMap(@NotNull PersistentHashMap<?, ?> map) {
        Path baseFile = map.getBaseFile();
        try {
            map.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        PersistentHashMap.deleteFilesStartingWith(baseFile.toFile());
    }

    @NotNull
    static Path getDataFile(@NotNull Path file) {
        return file.resolveSibling(file.getFileName() + DATA_FILE_EXTENSION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void put(Key key, Value value) throws IOException {
        if (this.myIsReadOnly) {
            throw new IncorrectOperationException();
        }
        Object object = this.getDataAccessLock();
        synchronized (object) {
            try {
                this.doPut(key, value);
            }
            catch (IOException ex) {
                this.myEnumerator.markCorrupted();
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPut(Key key, Value value) throws IOException {
        long newValueOffset = -1L;
        if (!this.myIntMapping) {
            BufferExposingByteArrayOutputStream bytes = new BufferExposingByteArrayOutputStream();
            AppendStream appenderStream = ourFlyweightAppenderStream.getValue();
            appenderStream.setOut(bytes);
            this.myValueExternalizer.save(appenderStream, value);
            appenderStream.setOut(null);
            newValueOffset = this.myValueStorage.appendBytes(bytes.toByteArraySequence(), 0L);
        }
        this.myEnumerator.lockStorageWrite();
        try {
            long oldValueOffset;
            this.myEnumerator.markDirty(true);
            if (this.myAppendCache != null) {
                this.myAppendCache.remove(key);
            }
            if (this.myDirectlyStoreLongFileOffsetMode) {
                if (this.myIntMapping) {
                    ((PersistentBTreeEnumerator)this.myEnumerator).putNonNegativeValue(key, ((Integer)value).intValue());
                    return;
                }
                oldValueOffset = ((PersistentBTreeEnumerator)this.myEnumerator).getNonNegativeValue(key);
                ((PersistentBTreeEnumerator)this.myEnumerator).putNonNegativeValue(key, newValueOffset);
            } else {
                int id = this.enumerate(key);
                if (this.myIntMapping) {
                    this.myEnumerator.myStorage.putInt(id + this.myParentValueRefOffset, (Integer)value);
                    return;
                }
                oldValueOffset = this.readValueId(id);
                this.updateValueId(id, newValueOffset, oldValueOffset, key, 0);
            }
            this.myLiveAndGarbageKeysCounter = oldValueOffset != 0L ? ++this.myLiveAndGarbageKeysCounter : (this.myLiveAndGarbageKeysCounter += 0x100000000L);
        }
        finally {
            this.myEnumerator.unlockStorageWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public int enumerate(Key name) throws IOException {
        if (this.myIsReadOnly) {
            throw new IncorrectOperationException();
        }
        Object object = this.getDataAccessLock();
        synchronized (object) {
            this.myIntAddressForNewRecord = this.canUseIntAddressForNewRecord(this.myValueStorage.getSize());
            return this.myEnumerator.enumerate(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void appendData(Key key, @NotNull ValueDataAppender appender) throws IOException {
        if (this.myIsReadOnly) {
            throw new IncorrectOperationException();
        }
        Object object = this.getDataAccessLock();
        synchronized (object) {
            try {
                this.doAppendData(key, appender);
            }
            catch (IOException ex) {
                this.myEnumerator.markCorrupted();
                throw ex;
            }
        }
    }

    private void doAppendData(Key key, @NotNull ValueDataAppender appender) throws IOException {
        assert (!this.myIntMapping);
        this.myEnumerator.markDirty(true);
        AppendStream appenderStream = ourFlyweightAppenderStream.getValue();
        BufferExposingByteArrayOutputStream stream = this.myAppendCache.get(key);
        appenderStream.setOut(stream);
        this.myValueStorage.checkAppendsAllowed(stream.size());
        appender.append(appenderStream);
        appenderStream.setOut(null);
    }

    @Override
    public final boolean processKeys(@NotNull Processor<? super Key> processor) throws IOException {
        Object object = this.getDataAccessLock();
        synchronized (object) {
            try {
                if (this.myAppendCache != null) {
                    this.myAppendCache.clear();
                }
                return this.myEnumerator.iterateData(processor);
            }
            catch (IOException e) {
                this.myEnumerator.markCorrupted();
                throw e;
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this.myEnumerator.isClosed();
    }

    @Override
    public boolean isDirty() {
        return this.myEnumerator.isDirty();
    }

    @Override
    public void markDirty() throws IOException {
        this.myEnumerator.markDirty(true);
    }

    @NotNull
    public Collection<Key> getAllKeysWithExistingMapping() throws IOException {
        ArrayList values = new ArrayList();
        this.processKeysWithExistingMapping(new CommonProcessors.CollectProcessor(values));
        return values;
    }

    public final boolean processKeysWithExistingMapping(@NotNull Processor<? super Key> processor) throws IOException {
        Object object = this.getDataAccessLock();
        synchronized (object) {
            try {
                if (this.myAppendCache != null) {
                    this.myAppendCache.clear();
                }
                return this.myEnumerator.processAllDataObject(processor, new PersistentEnumeratorBase.DataFilter(){

                    @Override
                    public boolean accept(int id) {
                        return PersistentHashMap.this.readValueId(id) != 0L;
                    }
                });
            }
            catch (IOException e) {
                this.myEnumerator.markCorrupted();
                throw e;
            }
        }
    }

    @Override
    public final Value get(Key key) throws IOException {
        Object object = this.getDataAccessLock();
        synchronized (object) {
            try {
                return this.doGet(key);
            }
            catch (IOException ex) {
                try {
                    this.myEnumerator.markCorrupted();
                }
                catch (Exception e) {
                    LOG.warn(e);
                }
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected Value doGet(Key key) throws IOException {
        Value valueRead;
        int id;
        long valueOffset;
        if (this.myAppendCache != null) {
            this.myAppendCache.remove(key);
        }
        this.myEnumerator.lockStorageRead();
        try {
            if (this.myDirectlyStoreLongFileOffsetMode) {
                valueOffset = ((PersistentBTreeEnumerator)this.myEnumerator).getNonNegativeValue(key);
                if (this.myIntMapping) {
                    Integer n = (int)valueOffset;
                    return (Value)n;
                }
                id = -1;
            } else {
                id = this.myEnumerator.tryEnumerate(key);
                if (id == 0) {
                    Value Value = null;
                    return Value;
                }
                if (this.myIntMapping) {
                    Integer n = this.myEnumerator.myStorage.getInt(id + this.myParentValueRefOffset);
                    return (Value)n;
                }
                valueOffset = this.readValueId(id);
            }
            if (valueOffset == 0L) {
                Value Value = null;
                return Value;
            }
        }
        finally {
            this.myEnumerator.unlockStorageRead();
        }
        PersistentHashMapValueStorage.ReadResult readResult = this.myValueStorage.readBytes(valueOffset);
        try (DataInputStream input = new DataInputStream(new UnsyncByteArrayInputStream(readResult.buffer));){
            valueRead = this.myValueExternalizer.read(input);
        }
        if (this.myValueStorage.performChunksCompaction(readResult.chunksCount)) {
            long newValueOffset = this.myValueStorage.compactChunks(new ValueDataAppender(){

                @Override
                public void append(DataOutput out) throws IOException {
                    PersistentHashMap.this.myValueExternalizer.save(out, valueRead);
                }
            }, readResult);
            this.myEnumerator.lockStorageWrite();
            try {
                this.myEnumerator.markDirty(true);
                if (this.myDirectlyStoreLongFileOffsetMode) {
                    ((PersistentBTreeEnumerator)this.myEnumerator).putNonNegativeValue(key, newValueOffset);
                } else {
                    this.updateValueId(id, newValueOffset, valueOffset, key, 0);
                }
                ++this.myLiveAndGarbageKeysCounter;
                this.myReadCompactionGarbageSize += readResult.buffer.length;
            }
            finally {
                this.myEnumerator.unlockStorageWrite();
            }
        }
        return valueRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean containsMapping(Key key) throws IOException {
        Object object = this.getDataAccessLock();
        synchronized (object) {
            return this.doContainsMapping(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doContainsMapping(Key key) throws IOException {
        if (this.myAppendCache != null) {
            this.myAppendCache.remove(key);
        }
        this.myEnumerator.lockStorageRead();
        try {
            if (this.myDirectlyStoreLongFileOffsetMode) {
                boolean bl = ((PersistentBTreeEnumerator)this.myEnumerator).getNonNegativeValue(key) != 0L;
                return bl;
            }
            int id = this.myEnumerator.tryEnumerate(key);
            if (id == 0) {
                boolean bl = false;
                return bl;
            }
            if (this.myIntMapping) {
                boolean bl = true;
                return bl;
            }
            boolean bl = this.readValueId(id) != 0L;
            return bl;
        }
        finally {
            this.myEnumerator.unlockStorageRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void remove(Key key) throws IOException {
        if (this.myIsReadOnly) {
            throw new IncorrectOperationException();
        }
        Object object = this.getDataAccessLock();
        synchronized (object) {
            this.doRemove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRemove(Key key) throws IOException {
        this.myEnumerator.lockStorageWrite();
        try {
            long record;
            if (this.myAppendCache != null) {
                this.myAppendCache.remove(key);
            }
            if (this.myDirectlyStoreLongFileOffsetMode) {
                assert (!this.myIntMapping);
                record = ((PersistentBTreeEnumerator)this.myEnumerator).getNonNegativeValue(key);
                if (record != 0L) {
                    ((PersistentBTreeEnumerator)this.myEnumerator).putNonNegativeValue(key, 0L);
                }
            } else {
                int id = this.myEnumerator.tryEnumerate(key);
                if (id == 0) {
                    return;
                }
                assert (!this.myIntMapping);
                this.myEnumerator.markDirty(true);
                record = this.readValueId(id);
                this.updateValueId(id, 0L, record, key, 0);
            }
            if (record != 0L) {
                ++this.myLiveAndGarbageKeysCounter;
                this.myLiveAndGarbageKeysCounter -= 0x100000000L;
            }
        }
        finally {
            this.myEnumerator.unlockStorageWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void force() {
        if (this.myIsReadOnly) {
            return;
        }
        if (myDoTrace) {
            LOG.info("Forcing " + this.myStorageFile);
        }
        Object object = this.getDataAccessLock();
        synchronized (object) {
            this.doForce();
        }
    }

    protected void doForce() {
        this.myEnumerator.lockStorageWrite();
        try {
            try {
                this.clearAppenderCaches();
            }
            finally {
                this.myEnumerator.force();
            }
        }
        finally {
            this.myEnumerator.unlockStorageWrite();
        }
    }

    private void clearAppenderCaches() {
        if (this.myIntMapping) {
            return;
        }
        this.myAppendCache.clear();
        this.myValueStorage.force();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws IOException {
        if (myDoTrace) {
            LOG.info("Closed " + this.myStorageFile);
        }
        Object object = this.getDataAccessLock();
        synchronized (object) {
            this.doClose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doClose() throws IOException {
        this.myEnumerator.lockStorageWrite();
        try {
            try {
                try {
                    if (this.myAppendCache != null) {
                        this.myAppendCacheFlusher.stop();
                        this.myAppendCache.clear();
                    }
                }
                catch (RuntimeException ex) {
                    Throwable cause = ex.getCause();
                    if (cause instanceof IOException) {
                        throw (IOException)cause;
                    }
                    throw ex;
                }
            }
            finally {
                PersistentHashMapValueStorage valueStorage = this.myValueStorage;
                try {
                    if (valueStorage != null) {
                        valueStorage.dispose();
                    }
                }
                finally {
                    this.myEnumerator.close();
                }
            }
        }
        finally {
            this.myEnumerator.unlockStorageWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public void compact() throws IOException {
        if (!this.isCompactionSupported()) {
            throw new IncorrectOperationException();
        }
        Object object = this.getDataAccessLock();
        synchronized (object) {
            this.force();
            LOG.info("Compacting " + this.myEnumerator.myFile);
            LOG.info("Live keys:" + (int)(this.myLiveAndGarbageKeysCounter / 0x100000000L) + ", dead keys:" + (int)(this.myLiveAndGarbageKeysCounter & 0xFFFFFFFFFFFFFFFFL) + ", read compaction size:" + this.myReadCompactionGarbageSize);
            long now = System.currentTimeMillis();
            Path oldDataFile = PersistentHashMap.getDataFile(this.myEnumerator.myFile);
            File[] oldFiles = PersistentHashMap.getFilesInDirectoryWithNameStartingWith(oldDataFile);
            Path newPath = oldDataFile.resolveSibling(oldDataFile.getFileName() + ".new");
            PersistentHashMapValueStorage.CreationTimeOptions options = this.myValueStorage.getOptions();
            final PersistentHashMapValueStorage newStorage = new PersistentHashMapValueStorage(newPath, options);
            this.myValueStorage.switchToCompactionMode();
            this.myEnumerator.markDirty(true);
            long sizeBefore = this.myValueStorage.getSize();
            this.myLiveAndGarbageKeysCounter = 0L;
            this.myReadCompactionGarbageSize = 0;
            try {
                if (PersistentHashMap.doNewCompact()) {
                    this.newCompact(newStorage);
                } else {
                    this.myEnumerator.traverseAllRecords(new PersistentEnumeratorBase.RecordsProcessor(){

                        @Override
                        public boolean process(int keyId) throws IOException {
                            long record = PersistentHashMap.this.readValueId(keyId);
                            if (record != 0L) {
                                PersistentHashMapValueStorage.ReadResult readResult = PersistentHashMap.this.myValueStorage.readBytes(record);
                                long value = newStorage.appendBytes(readResult.buffer, 0, readResult.buffer.length, 0L);
                                PersistentHashMap.this.updateValueId(keyId, value, record, null, this.getCurrentKey());
                                PersistentHashMap.this.myLiveAndGarbageKeysCounter = PersistentHashMap.this.myLiveAndGarbageKeysCounter + 0x100000000L;
                            }
                            return true;
                        }
                    });
                }
            }
            finally {
                newStorage.dispose();
            }
            this.myValueStorage.dispose();
            for (File f : oldFiles) {
                assert (FileUtil.deleteWithRenaming(f));
            }
            long newSize = newStorage.getSize();
            File[] newFiles = PersistentHashMap.getFilesInDirectoryWithNameStartingWith(newPath);
            File parentFile = newPath.getParent().toFile();
            String newBaseName = newPath.getFileName().toString();
            String oldDataFileBaseName = oldDataFile.getFileName().toString();
            for (File f : newFiles) {
                String nameAfterRename = StringUtil.replace(f.getName(), newBaseName, oldDataFileBaseName);
                FileUtil.rename(f, new File(parentFile, nameAfterRename));
            }
            this.myValueStorage = new PersistentHashMapValueStorage(oldDataFile, options);
            LOG.info("Compacted " + this.myEnumerator.myFile + ":" + sizeBefore + " bytes into " + newSize + " bytes in " + (System.currentTimeMillis() - now) + "ms.");
            this.myEnumerator.putMetaData(this.myLiveAndGarbageKeysCounter);
            this.myEnumerator.putMetaData2(this.myLargeIndexWatermarkId);
            if (myDoTrace) {
                LOG.assertTrue(this.myEnumerator.isDirty());
            }
        }
    }

    @ApiStatus.Internal
    public boolean isCompactionSupported() {
        return !this.myIsReadOnly && !this.myIntMapping;
    }

    private static File[] getFilesInDirectoryWithNameStartingWith(@NotNull Path fileFromDirectory) throws IOException {
        Path parentFile = fileFromDirectory.getParent();
        if (parentFile == null) {
            return ArrayUtil.EMPTY_FILE_ARRAY;
        }
        Path fileName = fileFromDirectory.getFileName();
        try (Stream<Path> children = Files.list(parentFile);){
            File[] fileArray = (File[])children.filter(p -> p.getFileName().toString().startsWith(fileName.toString())).map(p -> p.toFile()).toArray(File[]::new);
            return fileArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newCompact(@NotNull PersistentHashMapValueStorage newStorage) throws IOException {
        long started = System.currentTimeMillis();
        final ArrayList infos = new ArrayList(10000);
        this.myEnumerator.traverseAllRecords(new PersistentEnumeratorBase.RecordsProcessor(){

            @Override
            public boolean process(int keyId) {
                long record = PersistentHashMap.this.readValueId(keyId);
                if (record != 0L) {
                    infos.add(new CompactionRecordInfo(this.getCurrentKey(), record, keyId));
                }
                return true;
            }
        });
        LOG.info("Loaded mappings:" + (System.currentTimeMillis() - started) + "ms, keys:" + infos.size());
        started = System.currentTimeMillis();
        long fragments = 0L;
        if (!infos.isEmpty()) {
            try {
                fragments = this.myValueStorage.compactValues(infos, newStorage);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new IOException("Compaction failed", t);
            }
        }
        LOG.info("Compacted values for:" + (System.currentTimeMillis() - started) + "ms fragments:" + (int)fragments + ", new fragments:" + (fragments >> 32));
        started = System.currentTimeMillis();
        try {
            this.myEnumerator.lockStorageWrite();
            for (CompactionRecordInfo info : infos) {
                this.updateValueId(info.address, info.newValueAddress, info.valueAddress, null, info.key);
                this.myLiveAndGarbageKeysCounter += 0x100000000L;
            }
        }
        finally {
            this.myEnumerator.unlockStorageWrite();
        }
        LOG.info("Updated mappings:" + (System.currentTimeMillis() - started) + " ms");
    }

    private long readValueId(int keyId) {
        if (this.myDirectlyStoreLongFileOffsetMode) {
            return ((PersistentBTreeEnumerator)this.myEnumerator).keyIdToNonNegativeOffset(keyId);
        }
        long address = this.myEnumerator.myStorage.getInt(keyId + this.myParentValueRefOffset);
        if (address == 0L || address == -1L) {
            return 0L;
        }
        if (address < 0L) {
            address = -address - 1L;
        } else {
            long value = (long)this.myEnumerator.myStorage.getInt(keyId + this.myParentValueRefOffset + 4) & 0xFFFFFFFFL;
            address = (address << 32) + value & 0xBFFFFFFFFFFFFFFFL;
        }
        return address;
    }

    private void updateValueId(int keyId, long value, long oldValue, @Nullable Key key, int processingKey) throws IOException {
        boolean newKey;
        if (this.myDirectlyStoreLongFileOffsetMode) {
            ((PersistentBTreeEnumerator)this.myEnumerator).putNonNegativeValue(((InlineKeyDescriptor)this.myKeyDescriptor).fromInt(processingKey), value);
            return;
        }
        boolean bl = newKey = oldValue == 0L;
        if (newKey) {
            ++this.requests;
        }
        boolean defaultSizeInfo = true;
        if (this.myCanReEnumerate) {
            if (this.canUseIntAddressForNewRecord(value)) {
                defaultSizeInfo = false;
                this.myEnumerator.myStorage.putInt(keyId + this.myParentValueRefOffset, -((int)(value + 1L)));
                if (newKey) {
                    ++this.smallKeys;
                }
            } else if ((keyId < this.myLargeIndexWatermarkId || this.myLargeIndexWatermarkId == 0) && (newKey || this.canUseIntAddressForNewRecord(oldValue))) {
                this.myIntAddressForNewRecord = false;
                keyId = this.myEnumerator.reEnumerate(key == null ? this.myEnumerator.getValue(keyId, processingKey) : key);
                ++this.transformedKeys;
                if (this.myLargeIndexWatermarkId == 0) {
                    this.myLargeIndexWatermarkId = keyId;
                }
            }
        }
        if (defaultSizeInfo) {
            this.myEnumerator.myStorage.putInt(keyId + this.myParentValueRefOffset, (int)((value |= 0x4000000000000000L) >>> 32));
            this.myEnumerator.myStorage.putInt(keyId + this.myParentValueRefOffset + 4, (int)value);
            if (newKey) {
                ++this.largeKeys;
            }
        }
        if (newKey && IOStatistics.DEBUG && (this.requests & 0xFFFF) == 0) {
            IOStatistics.dump("small:" + this.smallKeys + ", large:" + this.largeKeys + ", transformed:" + this.transformedKeys + ",@" + this.getBaseFile());
        }
    }

    public String toString() {
        return super.toString() + ": " + this.myStorageFile;
    }

    PersistentHashMapValueStorage getValueStorage() {
        return this.myValueStorage;
    }

    public boolean getReadOnly() {
        return this.myIsReadOnly;
    }

    static {
        String property = System.getProperty("idea.initialIndexSize");
        INITIAL_INDEX_SIZE = property == null ? 4096 : Integer.valueOf(property);
        ourFlyweightAppenderStream = new ThreadLocalCachedValue<AppendStream>(){

            @Override
            @NotNull
            protected AppendStream create() {
                return new AppendStream();
            }
        };
    }

    static class CompactionRecordInfo {
        final int key;
        final int address;
        long valueAddress;
        long newValueAddress;
        byte[] value;

        CompactionRecordInfo(int _key, long _valueAddress, int _address) {
            this.key = _key;
            this.address = _address;
            this.valueAddress = _valueAddress;
        }
    }

    @ApiStatus.Experimental
    public static interface ValueDataAppender {
        public void append(DataOutput var1) throws IOException;
    }

    private static class AppendStream
    extends DataOutputStream {
        private AppendStream() {
            super(null);
        }

        private void setOut(BufferExposingByteArrayOutputStream stream) {
            this.out = stream;
        }
    }
}

