/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ExceptionUtil;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.channels.FileChannel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class FileChannelUtil {
    private static final Logger LOG = Logger.getInstance(FileChannelUtil.class);
    private static final Class<?> sunNioChFileChannelImpl = FileChannelUtil.setupFileChannelImpl();
    private static final MethodHandle setUnInterruptible = FileChannelUtil.setupUnInterruptibleHandle();

    FileChannelUtil() {
    }

    private static Class<?> setupFileChannelImpl() {
        try {
            return Class.forName("sun.nio.ch.FileChannelImpl");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    @Nullable
    private static MethodHandle setupUnInterruptibleHandle() {
        MethodHandle setUnInterruptible = null;
        try {
            if (sunNioChFileChannelImpl != null) {
                setUnInterruptible = MethodHandles.lookup().findVirtual(sunNioChFileChannelImpl, "setUninterruptible", MethodType.methodType(Void.TYPE));
            }
        }
        catch (NoSuchMethodException e) {
            LOG.info("interruptible FileChannel-s will be used for indexes");
        }
        catch (IllegalAccessException e) {
            LOG.error(e);
        }
        if (setUnInterruptible != null) {
            LOG.info("un-interruptible FileChannel-s will be used for indexes");
        } else {
            LOG.info("interruptible FileChannel-s will be used for indexes");
        }
        return setUnInterruptible;
    }

    @NotNull
    static FileChannel unInterruptible(@NotNull FileChannel channel) {
        try {
            if (setUnInterruptible != null && sunNioChFileChannelImpl != null && sunNioChFileChannelImpl.isInstance(channel)) {
                setUnInterruptible.invoke(channel);
            }
        }
        catch (Throwable e) {
            ExceptionUtil.rethrow(e);
        }
        return channel;
    }
}

