/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.exception;

import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.objectTree.ThrowableInterner;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

public class FrequentErrorLogger {
    private static final int REPORT_EVERY_NUM = 1000;
    @NotNull
    private final Map<Integer, Integer> ourReportedIssues = new ConcurrentHashMap<Integer, Integer>();
    @NotNull
    private final Logger myLogger;

    @NotNull
    public static FrequentErrorLogger newInstance(@NotNull Logger logger) {
        return new FrequentErrorLogger(logger);
    }

    private FrequentErrorLogger(@NotNull Logger logger) {
        this.myLogger = logger;
    }

    public void error(@NotNull String message, @NotNull Throwable t) {
        this.report(t, () -> this.myLogger.error(message, t));
    }

    public void error(@NotNull String message, @NotNull Throwable t, Attachment ... attachments) {
        this.report(t, () -> this.myLogger.error(message, t, attachments));
    }

    public void info(@NotNull String message, @NotNull Throwable t) {
        this.report(t, () -> this.myLogger.info(message, t));
    }

    private void report(@NotNull Throwable t, @NotNull Runnable writeToLog) {
        int hash = ThrowableInterner.computeHashCode(t);
        Integer reportedTimes = this.ourReportedIssues.get(hash);
        if (reportedTimes == null || reportedTimes > 1000) {
            writeToLog.run();
            this.ourReportedIssues.put(hash, 1);
        } else {
            this.ourReportedIssues.put(hash, reportedTimes + 1);
        }
    }
}

