/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Interner;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;

public class WeakInterner<T>
extends Interner<T> {
    private final ConcurrentMap<T, T> myMap;

    @Deprecated
    public WeakInterner() {
        this.myMap = ContainerUtil.createConcurrentWeakKeyWeakValueMap();
    }

    public WeakInterner(@NotNull TObjectHashingStrategy<? super T> strategy) {
        this.myMap = ContainerUtil.createConcurrentWeakKeyWeakValueMap(strategy);
    }

    @Override
    @NotNull
    public T intern(@NotNull T name) {
        return ConcurrencyUtil.cacheOrGet(this.myMap, name, name);
    }

    @Override
    public void clear() {
        this.myMap.clear();
    }

    @Override
    @NotNull
    public Set<T> getValues() {
        return new THashSet(this.myMap.values());
    }
}

