/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.concurrency.AppScheduledExecutorService;
import com.intellij.util.concurrency.BoundedScheduledExecutorService;
import com.intellij.util.concurrency.BoundedTaskExecutor;
import java.util.Comparator;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public final class AppExecutorUtil {
    @NotNull
    public static ScheduledExecutorService getAppScheduledExecutorService() {
        return AppScheduledExecutorService.getInstance();
    }

    @NotNull
    public static ExecutorService getAppExecutorService() {
        return ((AppScheduledExecutorService)AppExecutorUtil.getAppScheduledExecutorService()).backendExecutorService;
    }

    @NotNull
    public static ScheduledExecutorService createBoundedScheduledExecutorService(@NotNull String name, int maxThreads) {
        return new BoundedScheduledExecutorService(name, AppExecutorUtil.getAppExecutorService(), maxThreads);
    }

    @NotNull
    public static ExecutorService createBoundedApplicationPoolExecutor(@NotNull String name, int maxThreads) {
        return AppExecutorUtil.createBoundedApplicationPoolExecutor(name, AppExecutorUtil.getAppExecutorService(), maxThreads);
    }

    @ApiStatus.Internal
    @NotNull
    public static ExecutorService createBoundedApplicationPoolExecutor(@NotNull String name, int maxThreads, boolean changeThreadName) {
        return new BoundedTaskExecutor(name, AppExecutorUtil.getAppExecutorService(), maxThreads, changeThreadName);
    }

    @NotNull
    public static ExecutorService createBoundedApplicationPoolExecutor(@NotNull String name, @NotNull Executor backendExecutor, int maxThreads) {
        return new BoundedTaskExecutor(name, backendExecutor, maxThreads, true);
    }

    @NotNull
    public static ExecutorService createBoundedApplicationPoolExecutor(@NotNull String name, @NotNull Executor backendExecutor, int maxThreads, @NotNull Disposable parentDisposable) {
        BoundedTaskExecutor executor = new BoundedTaskExecutor(name, backendExecutor, maxThreads, true);
        Disposer.register(parentDisposable, () -> executor.shutdownNow());
        return executor;
    }

    @NotNull
    public static ExecutorService createCustomPriorityQueueBoundedApplicationPoolExecutor(@NotNull String name, @NotNull Executor backendExecutor, int maxThreads, @NotNull Comparator<? super Runnable> comparator) {
        return new BoundedTaskExecutor(name, backendExecutor, maxThreads, true, new PriorityBlockingQueue<Runnable>(11, comparator));
    }
}

