/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.ThrowableRunnable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public final class TimeoutUtil {
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.2")
    public static void executeWithTimeout(long timeout, long sleep, final @NotNull Runnable run) {
        long start = System.currentTimeMillis();
        final AtomicBoolean done = new AtomicBoolean(false);
        Thread thread = new Thread("Fast Function Thread@" + run.hashCode()){

            @Override
            public void run() {
                run.run();
                done.set(true);
            }
        };
        thread.start();
        while (!done.get() && System.currentTimeMillis() - start < timeout) {
            try {
                Thread.sleep(sleep);
            }
            catch (InterruptedException e) {
                // empty catch block
                break;
            }
        }
        if (!thread.isInterrupted()) {
            thread.stop();
        }
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.2")
    public static void executeWithTimeout(long timeout, @NotNull Runnable run) {
        TimeoutUtil.executeWithTimeout(timeout, 50L, run);
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static long getDurationMillis(long startNanoTime) {
        return (System.nanoTime() - startNanoTime) / 1000000L;
    }

    @ApiStatus.Experimental
    public static <E extends Throwable> long measureExecutionTime(@NotNull ThrowableRunnable<E> runnable) throws E {
        long startTime = System.nanoTime();
        runnable.run();
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime);
    }
}

