/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.UnsignedShortArrayList;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class PausesStat {
    private static final Logger LOG = Logger.getInstance(PausesStat.class);
    private static final int N_MAX = 100000;
    @NotNull
    private final String myName;
    private boolean started;
    private long startTimeStamp;
    private Thread currentThread;
    private final UnsignedShortArrayList durations = new UnsignedShortArrayList();
    private int maxDuration;
    private Object maxDurationDescription;
    private int totalNumberRecorded;
    private int indexToOverwrite;

    public PausesStat(@NotNull String name) {
        this.myName = name;
    }

    private synchronized void register(int duration, @NotNull String description) {
        if (duration > this.maxDuration) {
            this.maxDuration = duration;
            this.maxDurationDescription = description;
        }
        ++this.totalNumberRecorded;
        if (this.durations.size() == 100000) {
            this.durations.set(this.indexToOverwrite, duration);
            this.indexToOverwrite = (this.indexToOverwrite + 1) % 100000;
        } else {
            this.durations.add(duration);
        }
    }

    public void started() {
        LOG.assertTrue(!this.started);
        LOG.assertTrue(this.startTimeStamp == 0L, this.startTimeStamp);
        this.currentThread = Thread.currentThread();
        this.startTimeStamp = System.nanoTime();
        this.started = true;
    }

    public void finished(@NotNull String description) {
        LOG.assertTrue(this.currentThread == Thread.currentThread());
        LOG.assertTrue(this.started);
        this.currentThread = null;
        this.started = false;
        long finishStamp = System.nanoTime();
        long startTimeStamp = this.startTimeStamp;
        int durationMs = (int)TimeUnit.NANOSECONDS.toMillis(finishStamp - startTimeStamp);
        this.startTimeStamp = 0L;
        if (finishStamp - startTimeStamp < 0L || durationMs < 0) {
            return;
        }
        durationMs = Math.min(durationMs, Short.MAX_VALUE);
        this.register(durationMs, description);
    }

    public synchronized String statistics() {
        int number = this.durations.size();
        int[] duration = this.durations.toArray();
        int total = 0;
        for (int d : duration) {
            total += d;
        }
        return this.myName + " Statistics" + (this.totalNumberRecorded == number ? "" : " (" + this.totalNumberRecorded + " events was recorded in total, but only last " + number + " are reported here)") + ":\nEvent number:     " + number + "\nTotal time spent: " + total + "ms\nAverage duration: " + (number == 0 ? 0 : total / number) + "ms\nMedian  duration: " + ArrayUtil.averageAmongMedians(duration, 3) + "ms\nMax     duration: " + (this.maxDuration == 65535 ? ">" : "") + this.maxDuration + "ms (it was '" + this.maxDurationDescription + "')";
    }
}

