/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ColorHexUtil {
    @NotNull
    public static Color fromHex(@NotNull String str) {
        Color color = ColorHexUtil.fromHexOrNull(str);
        if (color != null) {
            return color;
        }
        throw new IllegalArgumentException("unsupported length:" + str);
    }

    @Nullable
    public static Color fromHexOrNull(@Nullable String str) {
        if (str == null) {
            return null;
        }
        int pos = str.startsWith("#") ? 1 : (str.startsWith("0x") ? 2 : 0);
        int len = str.length() - pos;
        if (len == 3) {
            return new Color(ColorHexUtil.fromHex1(str, pos), ColorHexUtil.fromHex1(str, pos + 1), ColorHexUtil.fromHex1(str, pos + 2), 255);
        }
        if (len == 4) {
            return new Color(ColorHexUtil.fromHex1(str, pos), ColorHexUtil.fromHex1(str, pos + 1), ColorHexUtil.fromHex1(str, pos + 2), ColorHexUtil.fromHex1(str, pos + 3));
        }
        if (len == 6) {
            return new Color(ColorHexUtil.fromHex2(str, pos), ColorHexUtil.fromHex2(str, pos + 2), ColorHexUtil.fromHex2(str, pos + 4), 255);
        }
        if (len == 8) {
            return new Color(ColorHexUtil.fromHex2(str, pos), ColorHexUtil.fromHex2(str, pos + 2), ColorHexUtil.fromHex2(str, pos + 4), ColorHexUtil.fromHex2(str, pos + 6));
        }
        return null;
    }

    @Nullable
    public static Color fromHex(@Nullable String str, @Nullable Color defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return ColorHexUtil.fromHex(str);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    private static int fromHex(@NotNull String str, int pos) {
        char ch = str.charAt(pos);
        if (ch >= '0' && ch <= '9') {
            return ch - 48;
        }
        if (ch >= 'A' && ch <= 'F') {
            return ch - 65 + 10;
        }
        if (ch >= 'a' && ch <= 'f') {
            return ch - 97 + 10;
        }
        throw new IllegalArgumentException("unsupported char at " + pos + ":" + str);
    }

    private static int fromHex1(@NotNull String str, int pos) {
        return 17 * ColorHexUtil.fromHex(str, pos);
    }

    private static int fromHex2(@NotNull String str, int pos) {
        return 16 * ColorHexUtil.fromHex(str, pos) + ColorHexUtil.fromHex(str, pos + 1);
    }
}

