/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.serialization;

import com.intellij.serialization.MutableAccessor;
import com.intellij.serialization.SerializationException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class FieldAccessor
implements MutableAccessor {
    private final Field myField;

    FieldAccessor(@NotNull Field field) {
        this.myField = field;
        field.setAccessible(true);
    }

    @Override
    public Object read(@NotNull Object o) {
        assert (this.myField.getDeclaringClass().isInstance(o)) : "Wrong class: " + o.getClass() + "; should be: " + this.myField.getDeclaringClass();
        try {
            return this.myField.get(o);
        }
        catch (IllegalAccessException e) {
            throw new SerializationException("Reading " + this.myField, e);
        }
    }

    @Override
    public Object readUnsafe(@NotNull Object o) throws IllegalAccessException {
        return this.myField.get(o);
    }

    @Override
    public int readInt(@NotNull Object o) throws IllegalAccessException {
        return this.myField.getInt(o);
    }

    @Override
    public long readLong(@NotNull Object o) throws IllegalAccessException {
        return this.myField.getLong(o);
    }

    @Override
    public float readFloat(@NotNull Object o) throws IllegalAccessException {
        return this.myField.getFloat(o);
    }

    @Override
    public double readDouble(@NotNull Object o) throws IllegalAccessException {
        return this.myField.getDouble(o);
    }

    @Override
    public boolean readBoolean(@NotNull Object o) throws IllegalAccessException {
        return this.myField.getBoolean(o);
    }

    @Override
    public void set(@NotNull Object host, @Nullable Object value) {
        try {
            this.myField.set(host, value);
        }
        catch (IllegalAccessException e) {
            throw new SerializationException("Writing " + this.myField, e);
        }
    }

    @Override
    public void setBoolean(@NotNull Object host, boolean value) {
        try {
            this.myField.setBoolean(host, value);
        }
        catch (IllegalAccessException e) {
            throw new SerializationException("Writing " + this.myField, e);
        }
    }

    @Override
    public void setInt(@NotNull Object host, int value) {
        try {
            this.myField.setInt(host, value);
        }
        catch (IllegalAccessException e) {
            throw new SerializationException("Writing " + this.myField, e);
        }
    }

    @Override
    public void setShort(@NotNull Object host, short value) {
        try {
            this.myField.setShort(host, value);
        }
        catch (IllegalAccessException e) {
            throw new SerializationException("Writing " + this.myField, e);
        }
    }

    @Override
    public void setLong(@NotNull Object host, long value) {
        try {
            this.myField.setLong(host, value);
        }
        catch (IllegalAccessException e) {
            throw new SerializationException("Writing " + this.myField, e);
        }
    }

    @Override
    public void setFloat(@NotNull Object host, float value) {
        try {
            this.myField.setFloat(host, value);
        }
        catch (IllegalAccessException e) {
            throw new SerializationException("Writing " + this.myField, e);
        }
    }

    @Override
    public void setDouble(@NotNull Object host, double value) {
        try {
            this.myField.setDouble(host, value);
        }
        catch (IllegalAccessException e) {
            throw new SerializationException("Writing " + this.myField, e);
        }
    }

    @Override
    public <T extends Annotation> T getAnnotation(@NotNull Class<T> annotationClass) {
        return this.myField.getAnnotation(annotationClass);
    }

    @Override
    @NotNull
    public String getName() {
        return this.myField.getName();
    }

    @Override
    @NotNull
    public Class<?> getValueClass() {
        return this.myField.getType();
    }

    @Override
    @NotNull
    public Type getGenericType() {
        return this.myField.getGenericType();
    }

    @Override
    public boolean isWritable() {
        return this.myField.isAccessible();
    }

    @NotNull
    public String toString() {
        return "FieldAccessor(name=" + this.myField.getName() + ", class=" + this.myField.getDeclaringClass().getName() + ")";
    }
}

