/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OSAgnosticPathUtil {
    public static final Comparator<String> COMPARATOR = (path1, path2) -> {
        if (path1 == path2) {
            return 0;
        }
        if (path1 == null) {
            return -1;
        }
        if (path2 == null) {
            return 1;
        }
        int length1 = path1.length();
        int length2 = path2.length();
        boolean ignoreCase = !SystemInfo.isFileSystemCaseSensitive;
        for (int pos = 0; pos < length1 && pos < length2; ++pos) {
            char ch2;
            char ch1 = path1.charAt(pos);
            if (ch1 == (ch2 = path2.charAt(pos))) continue;
            if (ch1 == '/') {
                if (ch2 == '\\') continue;
                return -1;
            }
            if (ch1 == '\\') {
                if (ch2 == '/') continue;
                return -1;
            }
            if (ch2 == '/' || ch2 == '\\') {
                return 1;
            }
            int diff = StringUtil.compare(ch1, ch2, ignoreCase);
            if (diff == 0) continue;
            return diff;
        }
        return Integer.compare(length1, length2);
    };

    private OSAgnosticPathUtil() {
    }

    public static boolean isAbsolute(@NotNull String path) {
        return path.length() > 2 && path.charAt(1) == ':' && OSAgnosticPathUtil.isSlash(path.charAt(2)) && OSAgnosticPathUtil.isDriveLetter(path.charAt(0)) || path.length() > 1 && OSAgnosticPathUtil.isSlash(path.charAt(0)) && path.charAt(1) == path.charAt(0) || path.startsWith("/");
    }

    public static boolean startsWith(@NotNull String path, @NotNull String prefix) {
        char next;
        int pathLength = path.length();
        int prefixLength = prefix.length();
        if (prefixLength == 0) {
            return true;
        }
        if (prefixLength > pathLength) {
            return false;
        }
        boolean ignoreCase = !SystemInfo.isFileSystemCaseSensitive;
        for (int pos = 0; pos < pathLength && pos < prefixLength; ++pos) {
            char ch2;
            char ch1 = path.charAt(pos);
            if (ch1 == (ch2 = prefix.charAt(pos))) continue;
            if (ch1 == '/') {
                if (ch2 == '\\') continue;
                return false;
            }
            if (ch1 == '\\') {
                if (ch2 == '/') continue;
                return false;
            }
            if (ch2 == '/' || ch2 == '\\') {
                return false;
            }
            if (StringUtil.compare(ch1, ch2, ignoreCase) == 0) continue;
            return false;
        }
        if (pathLength == prefixLength) {
            return true;
        }
        char lastPrefixChar = prefix.charAt(prefixLength - 1);
        int slashOrSeparatorIdx = prefixLength;
        if (lastPrefixChar == '/' || lastPrefixChar == '\\') {
            slashOrSeparatorIdx = prefixLength - 1;
        }
        return (next = path.charAt(slashOrSeparatorIdx)) == '/' || next == '\\';
    }

    @Nullable
    public static String getParent(@NotNull String path) {
        int length = path.length();
        int lastSeparator = OSAgnosticPathUtil.lastSeparatorIndex(path, length);
        if (lastSeparator < 0) {
            return null;
        }
        if (lastSeparator == length - 1) {
            lastSeparator = OSAgnosticPathUtil.lastSeparatorIndex(path, length - 2);
        }
        if (lastSeparator < 0) {
            return null;
        }
        if (length > 1 && OSAgnosticPathUtil.isSlash(path.charAt(0)) && path.charAt(1) == path.charAt(0)) {
            int prevSeparator;
            if (lastSeparator > 1 && (prevSeparator = OSAgnosticPathUtil.lastSeparatorIndex(path, lastSeparator - 1)) > 1) {
                return path.substring(0, lastSeparator);
            }
            return null;
        }
        if (lastSeparator == 2 && path.charAt(1) == ':' && OSAgnosticPathUtil.isDriveLetter(path.charAt(0))) {
            return path.substring(0, 3);
        }
        return path.substring(0, lastSeparator == 0 ? 1 : lastSeparator);
    }

    private static boolean isSlash(char c) {
        return c == '/' || c == '\\';
    }

    public static boolean isDriveLetter(char c) {
        return 'A' <= c && c <= 'Z' || 'a' <= c && c <= 'z';
    }

    private static int lastSeparatorIndex(String s, int from) {
        for (int i = Math.min(from, s.length() - 1); i >= 0; --i) {
            if (!OSAgnosticPathUtil.isSlash(s.charAt(i))) continue;
            return i;
        }
        return -1;
    }
}

