/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.NotNullComputable;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Computable<T>
extends Supplier<T> {
    public T compute();

    @Override
    default public T get() {
        return this.compute();
    }

    @Deprecated
    public static abstract class NotNullCachedComputable<T>
    implements NotNullComputable<T> {
        private T myValue;

        @NotNull
        protected abstract T internalCompute();

        @Override
        @NotNull
        public final T compute() {
            T value = this.myValue;
            if (value == null) {
                this.myValue = value = this.internalCompute();
            }
            return value;
        }
    }

    public static final class PredefinedValueComputable<T>
    implements Computable<T> {
        private final T myValue;

        public PredefinedValueComputable(@Nullable T value) {
            this.myValue = value;
        }

        @Override
        public T compute() {
            return this.myValue;
        }

        public String toString() {
            return "PredefinedValueComputable{" + this.myValue + "}";
        }
    }
}

