/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diagnostic;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.FixedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrequentEventDetector {
    private static final Logger LOG = Logger.getInstance(FrequentEventDetector.class);
    private long myStartedCounting = System.currentTimeMillis();
    private final AtomicInteger myEventsPosted = new AtomicInteger();
    private final AtomicInteger myLastTraceId = new AtomicInteger();
    private final Map<String, Integer> myRecentTraces = new FixedHashMap<String, Integer>(50);
    private final int myEventCountThreshold;
    private final int myTimeSpanMs;
    private final Level myLevel;
    private static final AtomicInteger disableRequests = new AtomicInteger();

    public FrequentEventDetector(int eventCountThreshold, int timeSpanMs) {
        this(eventCountThreshold, timeSpanMs, Level.INFO);
    }

    public FrequentEventDetector(int eventCountThreshold, int timeSpanMs, @NotNull Level level) {
        this.myEventCountThreshold = eventCountThreshold;
        this.myTimeSpanMs = timeSpanMs;
        this.myLevel = level;
    }

    @Nullable
    public String getMessageOnEvent(@NotNull Object event) {
        if (disableRequests.get() == 0 && this.myEventsPosted.incrementAndGet() > this.myEventCountThreshold && this.manyEventsHappenedInSmallTimeSpan()) {
            return this.generateMessage(event);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean manyEventsHappenedInSmallTimeSpan() {
        boolean shouldLog = false;
        AtomicInteger atomicInteger = this.myEventsPosted;
        synchronized (atomicInteger) {
            if (this.myEventsPosted.get() > this.myEventCountThreshold) {
                long timeNow = System.currentTimeMillis();
                shouldLog = timeNow - this.myStartedCounting < (long)this.myTimeSpanMs;
                this.myEventsPosted.set(0);
                this.myStartedCounting = timeNow;
            }
        }
        return shouldLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private String generateMessage(@NotNull Object event) {
        int traceId;
        boolean logTrace;
        String trace = ExceptionUtil.getThrowableText(new Throwable());
        AtomicInteger atomicInteger = this.myEventsPosted;
        synchronized (atomicInteger) {
            Integer existingTraceId = this.myRecentTraces.get(trace);
            boolean bl = logTrace = existingTraceId == null;
            if (logTrace) {
                traceId = this.myLastTraceId.incrementAndGet();
                this.myRecentTraces.put(trace, traceId);
            } else {
                traceId = existingTraceId;
            }
        }
        return "Too many events posted, #" + traceId + ". Event: " + event + (logTrace ? "\n" + trace : "");
    }

    public void logMessage(@NotNull String message) {
        if (this.myLevel == Level.INFO) {
            LOG.info(message);
        } else if (this.myLevel == Level.WARN) {
            LOG.warn(message);
        } else {
            LOG.error(message);
        }
    }

    public void eventHappened(@NotNull Object event) {
        String message = this.getMessageOnEvent(event);
        if (message != null) {
            this.logMessage(message);
        }
    }

    public static void disableUntil(@NotNull Disposable reenable) {
        disableRequests.incrementAndGet();
        Disposer.register(reenable, () -> disableRequests.decrementAndGet());
    }

    public static enum Level {
        INFO,
        WARN,
        ERROR;

    }
}

